/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.bind;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.tentackle.bind.BindingException;
import org.tentackle.bind.BindingMember;
import org.tentackle.bind.BindingVetoException;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.FormTableRowObject;
import org.tentackle.swing.bind.AbstractFormBinding;
import org.tentackle.swing.bind.FormTableBinder;
import org.tentackle.swing.bind.FormTableBinding;
import org.tentackle.validate.ChangeableBindingEvaluator;
import org.tentackle.validate.MandatoryBindingEvaluator;
import org.tentackle.validate.ValidationContext;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationScopeFactory;
import org.tentackle.validate.Validator;
import org.tentackle.validate.scope.MandatoryScope;

public class DefaultFormTableBinding
extends AbstractFormBinding
implements FormTableBinding {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFormTableBinding.class);
    private final int mColumn;
    private FormTableRowObject rowObject;
    private Character convert;
    private Boolean autoSelect;
    private Integer maxCol;
    private Integer scale;
    private boolean mandatory;
    private boolean changeable;
    private List<Validator> mandatoryValidators;
    private List<Validator> changeableValidators;
    private long lastTablePaintCount;

    public DefaultFormTableBinding(FormTableBinder binder, BindingMember[] parents, BindingMember member, int mColumn, String columnOptions) {
        super(binder, parents, member);
        this.mColumn = mColumn;
        this.processOptions(columnOptions);
        this.determineValidators();
        this.verifyType();
    }

    @Override
    public FormTableBinder getBinder() {
        return (FormTableBinder)super.getBinder();
    }

    protected Class<?> getViewType() {
        return this.getBinder().getModel().getColumnClass(this.mColumn);
    }

    protected void determineValidators() {
        super.determineValidators();
        List validators = this.getValidators();
        if (validators != null) {
            for (Validator validator : validators) {
                if (validator instanceof MandatoryBindingEvaluator) {
                    if (this.mandatoryValidators == null) {
                        this.mandatoryValidators = new ArrayList<Validator>();
                    }
                    this.mandatoryValidators.add(validator);
                }
                if (!(validator instanceof ChangeableBindingEvaluator)) continue;
                if (this.changeableValidators == null) {
                    this.changeableValidators = new ArrayList<Validator>();
                }
                this.changeableValidators.add(validator);
            }
        }
    }

    protected void processOptions(String columnOptions) {
        if (columnOptions != null) {
            StringTokenizer stok = new StringTokenizer(columnOptions.toUpperCase(), ",");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                if (this.processOption(token)) continue;
                throw new BindingException("unsupported @Bindable option \"" + token + "\") in " + this.getMember());
            }
        }
    }

    protected boolean processOption(String option) {
        boolean processed = false;
        if ("UC".equals(option)) {
            this.convert = Character.valueOf('^');
            processed = true;
        } else if ("LC".equals(option)) {
            this.convert = Character.valueOf('v');
            processed = true;
        } else if ("AUTOSELECT".equals(option)) {
            this.autoSelect = true;
            processed = true;
        } else if ("-AUTOSELECT".equals(option)) {
            this.autoSelect = false;
            processed = true;
        } else if ("UNSIGNED".equals(option)) {
            processed = true;
        } else if ("-UNSIGNED".equals(option)) {
            processed = true;
        } else if (option.startsWith("MAXCOL=")) {
            try {
                this.maxCol = Integer.parseInt(option.substring("MAXCOL".length() + 1));
                processed = true;
            }
            catch (NumberFormatException ex) {
                throw new BindingException("invalid MAXCOL @Bindable option \"" + option + "\") in " + this.getMember(), (Throwable)ex);
            }
        } else if (option.startsWith("SCALE=")) {
            try {
                this.scale = Integer.parseInt(option.substring("SCALE".length() + 1));
                processed = true;
            }
            catch (NumberFormatException ex) {
                throw new BindingException("invalid SCALE @Bindable option \"" + option + "\") in " + this.getMember(), (Throwable)ex);
            }
        } else if ("COL".equals(option)) {
            processed = true;
        }
        return processed;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setChangeable(boolean changeable) {
        this.changeable = changeable;
    }

    public boolean isChangeable() {
        return this.changeable;
    }

    @Override
    public FormTableRowObject getBoundRootObject() {
        return this.rowObject;
    }

    public void fireToView(Object parent, Object modelValue) throws BindingVetoException {
        ValidationContext validationContext;
        MandatoryScope scope;
        if (this.mandatoryValidators != null && !this.mandatoryValidators.isEmpty()) {
            boolean cellIsMandatory = false;
            for (Validator validator : this.mandatoryValidators) {
                if (parent == null || !(scope = ValidationScopeFactory.getInstance().getMandatoryScope()).appliesTo(validator.getConfiguredScopes(validationContext = new ValidationContext(this.getMember().getMemberPath(), this.getMember().getType(), modelValue, parent, (ValidationScope)scope))) || !validator.isConditionValid(validationContext) || !((MandatoryBindingEvaluator)validator).isMandatory(validationContext)) continue;
                cellIsMandatory = true;
                break;
            }
            this.setMandatory(cellIsMandatory);
        }
        if (this.changeableValidators != null && !this.changeableValidators.isEmpty()) {
            boolean cellIsChangeable = false;
            for (Validator validator : this.changeableValidators) {
                if (parent == null || !(scope = ValidationScopeFactory.getInstance().getChangeableScope()).appliesTo(validator.getConfiguredScopes(validationContext = new ValidationContext(this.getMember().getMemberPath(), this.getMember().getType(), modelValue, parent, (ValidationScope)scope))) || !validator.isConditionValid(validationContext) || !((ChangeableBindingEvaluator)validator).isChangeable(validationContext)) continue;
                cellIsChangeable = true;
                break;
            }
            this.setChangeable(cellIsChangeable);
        }
        super.fireToView(parent, modelValue);
    }

    protected void updateView(Object parent, Object value, boolean honourResyncByVetoException) {
        FormTable table = this.getBinder().getModel().getTable();
        if (table == null) {
            throw new BindingException("table not set in table model");
        }
        long paintCount = table.getPaintCount();
        if (paintCount != this.lastTablePaintCount) {
            super.updateView(parent, value, honourResyncByVetoException);
            this.lastTablePaintCount = paintCount;
        }
    }

    @Override
    public void setBoundRootObject(FormTableRowObject rowObject) {
        this.rowObject = rowObject;
    }

    protected boolean isValidationRequired() {
        return true;
    }

    protected String viewComponentToString() {
        return this.getMember() + ":" + this.mColumn;
    }

    public Object getViewValue() {
        return this.rowObject.getValueAt(this.mColumn);
    }

    @Override
    public int getColumn() {
        return this.mColumn;
    }

    protected void updateView(Object value) {
    }

    @Override
    public Character getConvert() {
        return this.convert;
    }

    @Override
    public Boolean isAutoSelect() {
        return this.autoSelect;
    }

    @Override
    public Integer getMaxColumns() {
        return this.maxCol;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }
}

