/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.tentackle.swing.FormCheckBox;
import org.tentackle.swing.FormComponentCellEditor;
import org.tentackle.swing.FormTableCellRenderer;
import org.tentackle.swing.plaf.PlafUtilities;

public class AcceptDenyCheckBox
extends FormCheckBox {
    private boolean invert;

    public AcceptDenyCheckBox(boolean invert) {
        this.setInvert(invert);
        this.setIcon(PlafUtilities.getInstance().getIcon("cancel_mini"));
        this.setSelectedIcon(PlafUtilities.getInstance().getIcon("ok_mini"));
    }

    public AcceptDenyCheckBox() {
        this(false);
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public static TableCellRenderer getTableCellRenderer(boolean invert) {
        return new BooleanTableCellRenderer(invert);
    }

    public static TableCellRenderer getTableCellRenderer() {
        return AcceptDenyCheckBox.getTableCellRenderer(false);
    }

    public static TableCellEditor getTableCellEditor(boolean invert) {
        AcceptDenyCheckBox box = new AcceptDenyCheckBox(invert);
        box.setHorizontalAlignment(0);
        box.setBackground(PlafUtilities.getInstance().getTableFocusCellBackgroundColor());
        return new FormComponentCellEditor(box);
    }

    public static TableCellEditor getTableCellEditor() {
        return AcceptDenyCheckBox.getTableCellEditor(false);
    }

    private static class BooleanTableCellRenderer
    extends FormTableCellRenderer {
        private boolean invert;
        private Icon cancelIcon;
        private Icon okIcon;

        BooleanTableCellRenderer(boolean invert) {
            this.invert = invert;
            this.cancelIcon = PlafUtilities.getInstance().getIcon("cancel_mini");
            this.okIcon = PlafUtilities.getInstance().getIcon("ok_mini");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setValue(null);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            ((JLabel)this.getComponent()).setIcon((value != null && (Boolean)value != false) ^ this.invert ? this.okIcon : this.cancelIcon);
            return comp;
        }
    }
}

