/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.text.MessageFormat;
import java.text.ParseException;
import javax.swing.text.Document;
import org.tentackle.swing.AbstractNumberFormField;
import org.tentackle.swing.SwingSwingBundle;

public class ByteFormField
extends AbstractNumberFormField {
    private byte minValue = (byte)-128;
    private byte maxValue = (byte)127;

    public ByteFormField(Document doc, int columns) {
        super(doc, columns);
    }

    public ByteFormField(int columns) {
        this((Document)null, columns);
    }

    public ByteFormField() {
        this(0);
    }

    public void setMinValue(byte minValue) {
        this.minValue = minValue;
    }

    public byte getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(byte maxValue) {
        this.maxValue = maxValue;
    }

    public byte getMaxValue() {
        return this.maxValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Byte getFormValue() {
        String str = this.getText();
        if (str == null || (str = str.replace(this.getFiller(), ' ').trim()).length() <= 0) return null;
        try {
            Number value = this.decimalFormat.parse(str);
            if (value instanceof Long) {
                if ((Long)value > (long)this.maxValue) {
                    this.errorOffset = 0;
                    this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE <= {0}"), this.maxValue);
                    return null;
                } else {
                    if ((Long)value >= (long)this.minValue) return ((Long)value).byteValue();
                    this.errorOffset = 0;
                    this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("VALUE MUST BE >= {0}"), this.minValue);
                }
                return null;
            } else {
                this.errorOffset = 0;
                this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("INVALID NUMBER: {0}"), str);
            }
            return null;
        }
        catch (ParseException e) {
            this.errorOffset = e.getErrorOffset();
            this.errorMessage = MessageFormat.format(SwingSwingBundle.getString("INVALID NUMBER: {0}"), str);
        }
        return null;
    }

    public byte getByteValue() {
        Byte value = this.getFormValue();
        return value == null ? (byte)0 : value;
    }

    public void setByteValue(byte value) {
        this.setFormValue(value);
    }
}

