/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.util.Arrays;
import org.tentackle.swing.ComponentGroup;
import org.tentackle.swing.FormLayoutComparator;

public class FocusTraversalGroup
extends ComponentGroup {
    private FormLayoutComparator layoutComparator;
    private Component[] sortedComponents;

    public FocusTraversalGroup(FormLayoutComparator layoutComparator) {
        if (layoutComparator == null) {
            throw new IllegalArgumentException("layout comparator must not be null");
        }
        this.layoutComparator = layoutComparator;
    }

    public FocusTraversalGroup() {
        this(new FormLayoutComparator());
    }

    @Override
    public boolean addComponent(Component component) {
        this.invalidateSortedComponents();
        return super.addComponent(component);
    }

    @Override
    public boolean removeComponent(Component component) {
        this.invalidateSortedComponents();
        return super.removeComponent(component);
    }

    public boolean isHorizontal() {
        return this.layoutComparator.isHorizontal();
    }

    public void setHorizontal(boolean horizontal) {
        this.invalidateSortedComponents();
        this.layoutComparator.setHorizontal(horizontal);
    }

    public boolean isLeftToRight() {
        return this.layoutComparator.isLeftToRight();
    }

    public void setLeftToRight(boolean leftToRight) {
        this.invalidateSortedComponents();
        this.layoutComparator.setLeftToRight(leftToRight);
    }

    public int getTolerance() {
        return this.layoutComparator.getTolerance();
    }

    public void setTolerance(int tolerance) {
        this.invalidateSortedComponents();
        this.layoutComparator.setTolerance(tolerance);
    }

    public Component getComponentAfter(Component component) {
        Component[] comps = this.getSortedComponents();
        for (int i = 0; i < comps.length - 1; ++i) {
            if (comps[i] != component) continue;
            return comps[i + 1];
        }
        return null;
    }

    public Component getComponentBefore(Component component) {
        Component[] comps = this.getSortedComponents();
        for (int i = comps.length - 1; i > 0; --i) {
            if (comps[i] != component) continue;
            return comps[i - 1];
        }
        return null;
    }

    public Component getLastComponent() {
        Component[] comps = this.getSortedComponents();
        return comps.length > 0 ? comps[comps.length - 1] : null;
    }

    public Component getFirstComponent() {
        Component[] comps = this.getSortedComponents();
        return comps.length > 0 ? comps[0] : null;
    }

    private void invalidateSortedComponents() {
        this.sortedComponents = null;
    }

    private Component[] getSortedComponents() {
        if (this.sortedComponents == null) {
            this.sortedComponents = this.getComponents();
            Arrays.sort(this.sortedComponents, this.layoutComparator);
        }
        return this.sortedComponents;
    }
}

