/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.swing.FormUtilities;

public class FormEventQueue
extends EventQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormEventQueue.class);
    public static long dropEventDefaultTime = 250L;
    private Predicate<AWTEvent> eventFilter;
    private long dropEventTime;

    public void dropEvents(long millis, Predicate<AWTEvent> eventFilter) {
        this.dropEventTime = System.currentTimeMillis() + millis;
        this.eventFilter = eventFilter;
    }

    public void dropKeyEvents() {
        this.dropEvents(dropEventDefaultTime, e -> e instanceof KeyEvent);
    }

    public void dropMouseEvents() {
        this.dropEvents(dropEventDefaultTime, e -> e instanceof MouseEvent);
    }

    @Override
    public AWTEvent getNextEvent() throws InterruptedException {
        Object object;
        MouseEvent me;
        AWTEvent event = super.getNextEvent();
        while (this.eventFilter != null && this.eventFilter.test(event)) {
            long eventTime = event instanceof InputEvent ? ((InputEvent)event).getWhen() : System.currentTimeMillis();
            if (eventTime <= this.dropEventTime) continue;
            this.eventFilter = null;
        }
        if (event instanceof MouseEvent && (me = (MouseEvent)event).isShiftDown() && me.isControlDown() && me.isPopupTrigger() && LOGGER.isInfoLoggable() && (object = me.getSource()) instanceof Component) {
            Component comp;
            Point p = me.getPoint();
            ArrayList<Component> dumpedComponents = new ArrayList<Component>();
            if (object instanceof JFrame) {
                Component comp2;
                Container pane;
                Component comp3;
                Component glass = ((JFrame)object).getGlassPane();
                if (glass != null && (comp3 = SwingUtilities.getDeepestComponentAt(glass, p.x - glass.getX(), p.y - glass.getY())) != null) {
                    LOGGER.info("component hierarchy for glass pane " + ReflectionHelper.getClassBaseName(glass.getClass()) + (glass.getName() == null ? "" : " (" + glass.getName() + ")") + ":\n" + FormUtilities.getInstance().dumpComponentHierarchy(comp3, me), new Object[0]);
                    dumpedComponents.add(comp3);
                }
                if ((pane = ((JFrame)object).getContentPane()) != null && (comp2 = SwingUtilities.getDeepestComponentAt(pane, p.x - pane.getX(), p.y - pane.getY())) != null && !dumpedComponents.contains(comp2)) {
                    LOGGER.info("component hierarchy for content pane " + ReflectionHelper.getClassBaseName(pane.getClass()) + (pane.getName() == null ? "" : " (" + pane.getName() + ")") + ":\n" + FormUtilities.getInstance().dumpComponentHierarchy(comp2, me), new Object[0]);
                    dumpedComponents.add(comp2);
                }
            }
            if ((comp = SwingUtilities.getDeepestComponentAt((Component)object, p.x, p.y)) != null && !dumpedComponents.contains(comp)) {
                LOGGER.info("component hierarchy for " + ReflectionHelper.getClassBaseName(comp.getClass()) + (comp.getName() == null ? "" : " (" + comp.getName() + ")") + ":\n" + FormUtilities.getInstance().dumpComponentHierarchy(comp, me), new Object[0]);
            }
        }
        return event;
    }
}

