/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormFieldComponentPanel;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.StringFormField;
import org.tentackle.swing.plaf.PlafUtilities;

public class FormFileChooser
extends FormFieldComponentPanel {
    private String startDir;
    private String description;
    private int fileSelectionMode;
    private String[] extensions;
    private boolean changeable = true;
    private FormButton browseButton;
    private StringFormField pathField;
    private FormButton unlinkButton;

    public FormFileChooser(String startDir, String description, int fileSelectionMode, String[] extensions) {
        this.startDir = startDir;
        this.description = description;
        this.fileSelectionMode = fileSelectionMode;
        this.extensions = extensions;
        this.initComponents();
    }

    public FormFileChooser() {
        this(null, null, 2, null);
    }

    @Override
    public void setFormComponent(FormComponent comp) {
        throw new IllegalAccessError("changing the component is not allowed");
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (name != null) {
            ((Component)((Object)this.getFormComponent())).setName(name + "/filename");
            this.browseButton.setName(name + "/browse");
        } else {
            ((Component)((Object)this.getFormComponent())).setName("filename");
            this.browseButton.setName("browse");
        }
    }

    public void setFileSelectionMode(int mode) {
        this.fileSelectionMode = mode;
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public void setExtensions(String[] ext) {
        this.extensions = ext;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        return this.description;
    }

    public void setStartDir(String dir) {
        this.startDir = dir;
    }

    public String getStartDir() {
        return this.startDir;
    }

    @Override
    public void setCellEditorUsage(boolean flag) {
        super.setCellEditorUsage(flag);
        this.browseButton.setFocusable(!flag);
        this.unlinkButton.setFocusable(!flag);
    }

    @Override
    public void setChangeable(boolean changeable) {
        this.changeable = changeable;
        this.browseButton.setEnabled(changeable);
        this.unlinkButton.setEnabled(changeable);
    }

    @Override
    public boolean isChangeable() {
        return this.changeable;
    }

    private void initComponents() {
        this.pathField = (StringFormField)this.getFormComponent();
        this.browseButton = new FormButton();
        this.unlinkButton = new FormButton();
        this.setLayout(new GridBagLayout());
        this.pathField.setEditable(false);
        this.pathField.setName("filename");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.pathField, gridBagConstraints);
        this.browseButton.setFormTraversable(true);
        this.browseButton.setIcon(PlafUtilities.getInstance().getIcon("open"));
        this.browseButton.setToolTipText("\u00f6ffnen");
        this.browseButton.setMargin(new Insets(2, 2, 2, 2));
        this.browseButton.setName("browse");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormFileChooser.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.browseButton, gridBagConstraints);
        this.unlinkButton.setFormTraversable(true);
        this.unlinkButton.setIcon(PlafUtilities.getInstance().getIcon("clear"));
        this.unlinkButton.setToolTipText("l\u00f6schen");
        this.unlinkButton.setMargin(new Insets(2, 2, 2, 2));
        this.unlinkButton.setName("unlink");
        this.unlinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormFileChooser.this.unlinkButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.unlinkButton, gridBagConstraints);
    }

    private void unlinkButtonActionPerformed(ActionEvent evt) {
        this.pathField.clearText();
        if (this.isAutoUpdate()) {
            this.fireValueEntered();
            FormUtilities.getInstance().doValidate(this);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(this.startDir);
        fc.setFileFilter(new ExtensionFileFilter());
        fc.setFileSelectionMode(this.fileSelectionMode);
        if (fc.showOpenDialog(this) == 0) {
            this.pathField.setText(fc.getSelectedFile().getPath());
            if (this.isAutoUpdate()) {
                this.fireValueEntered();
                FormUtilities.getInstance().doValidate(this);
            }
        }
    }

    private class ExtensionFileFilter
    extends FileFilter {
        private ExtensionFileFilter() {
        }

        @Override
        public String getDescription() {
            return FormFileChooser.this.description;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            if (f.isFile() && FormFileChooser.this.extensions != null) {
                String name = f.getName();
                for (int i = 0; i < FormFileChooser.this.extensions.length; ++i) {
                    if (!name.endsWith(FormFileChooser.this.extensions[i])) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

