/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.bind;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.bind.AbstractBindingFactory;
import org.tentackle.bind.BindingException;
import org.tentackle.bind.BindingMember;
import org.tentackle.common.Service;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.swing.BindableTableModel;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormContainer;
import org.tentackle.swing.bind.DefaultFormComponentBinder;
import org.tentackle.swing.bind.DefaultFormComponentBinding;
import org.tentackle.swing.bind.DefaultFormTableBinder;
import org.tentackle.swing.bind.DefaultFormTableBinding;
import org.tentackle.swing.bind.FormBindingFactory;
import org.tentackle.swing.bind.FormComponentBinder;
import org.tentackle.swing.bind.FormComponentBinding;
import org.tentackle.swing.bind.FormTableBinder;
import org.tentackle.swing.bind.FormTableBinding;

@Service(value=FormBindingFactory.class)
public class DefaultFormBindingFactory
extends AbstractBindingFactory
implements FormBindingFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFormBindingFactory.class);
    private final Map<Class<? extends FormComponent>, Class<? extends FormComponentBinding>> componentClassMap = new ConcurrentHashMap<Class<? extends FormComponent>, Class<? extends FormComponentBinding>>();
    private final Map<Class<? extends FormComponent>, Class<? extends FormComponentBinding>> allComponentClassMap = new ConcurrentHashMap<Class<? extends FormComponent>, Class<? extends FormComponentBinding>>();
    private final Map<Class<?>, Class<? extends FormTableBinding>> tableClassMap = new ConcurrentHashMap();
    private final Map<Class<?>, Class<? extends FormTableBinding>> allTableClassMap = new ConcurrentHashMap();

    @Override
    public Class<? extends FormComponentBinding> setFormComponentBindingClass(Class<? extends FormComponent> componentClass, Class<? extends FormComponentBinding> bindingClass) {
        return this.componentClassMap.put(componentClass, bindingClass);
    }

    @Override
    public Class<? extends FormComponentBinding> getFormComponentBindingClass(Class<? extends FormComponent> componentClass) {
        Class<? extends FormComponentBinding> bindingClass = this.allComponentClassMap.get(componentClass);
        if (bindingClass == null) {
            Class<? extends FormComponent> clazz = componentClass;
            while (FormComponent.class.isAssignableFrom(clazz) && (bindingClass = this.componentClassMap.get(clazz)) == null) {
                clazz = clazz.getSuperclass();
            }
            this.allComponentClassMap.put(componentClass, bindingClass == null ? FormComponentBinding.class : bindingClass);
        } else if (bindingClass == FormComponentBinding.class) {
            bindingClass = null;
        }
        return bindingClass;
    }

    @Override
    public Class<? extends FormTableBinding> setFormTableBindingClass(Class<?> modelClass, Class<? extends FormTableBinding> bindingClass) {
        return this.tableClassMap.put(modelClass, bindingClass);
    }

    @Override
    public Class<? extends FormTableBinding> getFormTableBindingClass(Class<?> modelClass) {
        Class<? extends FormTableBinding> bindingClass = this.allTableClassMap.get(modelClass);
        if (bindingClass == null) {
            for (Class<?> clazz = modelClass; clazz != null && (bindingClass = this.tableClassMap.get(clazz)) == null; clazz = clazz.getSuperclass()) {
            }
            this.allTableClassMap.put(modelClass, bindingClass == null ? FormTableBinding.class : bindingClass);
        } else if (bindingClass == FormTableBinding.class) {
            bindingClass = null;
        }
        return bindingClass;
    }

    @Override
    public FormComponentBinding createFormComponentBinding(FormComponentBinder binder, BindingMember[] parents, BindingMember member, FormComponent component, String componentOptions) {
        FormComponentBinding binding;
        Class<? extends FormComponentBinding> bindingClass = this.getFormComponentBindingClass(component.getClass());
        if (bindingClass != null) {
            try {
                Constructor<? extends FormComponentBinding> con = bindingClass.getConstructor(FormComponentBinder.class, BindingMember[].class, BindingMember.class, FormComponent.class, String.class);
                binding = con.newInstance(binder, parents, member, component, componentOptions);
            }
            catch (Exception ex) {
                throw new BindingException("could not instantiate binding " + bindingClass.getName(), (Throwable)ex);
            }
        } else {
            binding = new DefaultFormComponentBinding(binder, parents, member, component, componentOptions);
        }
        LOGGER.fine("created component binding {0}", new Object[]{binding});
        return binding;
    }

    @Override
    public FormComponentBinder createFormComponentBinder(FormContainer container) {
        return new DefaultFormComponentBinder(container);
    }

    @Override
    public FormTableBinding createFormTableBinding(FormTableBinder binder, BindingMember[] parents, BindingMember member, int mColumn, String columnOptions) {
        FormTableBinding binding;
        Class<? extends FormTableBinding> bindingClass = this.getFormTableBindingClass(member.getType());
        if (bindingClass != null) {
            try {
                Constructor<? extends FormTableBinding> con = bindingClass.getConstructor(FormTableBinder.class, BindingMember[].class, BindingMember.class, Integer.TYPE, String.class);
                binding = con.newInstance(binder, parents, member, mColumn, columnOptions);
            }
            catch (Exception ex) {
                throw new BindingException("could not instantiate binding " + bindingClass.getName(), (Throwable)ex);
            }
        } else {
            binding = new DefaultFormTableBinding(binder, parents, member, mColumn, columnOptions);
        }
        LOGGER.fine("created table binding {0}", new Object[]{binding});
        return binding;
    }

    public FormTableBinder createFormTableBinder(BindableTableModel model) {
        return new DefaultFormTableBinder(model);
    }
}

