/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.tentackle.misc.ShortLongText;

public class TPopupRenderer
extends JPanel
implements ListCellRenderer {
    private final JLabel leftLabel;
    private final JLabel rightLabel;
    private int minLeftWidth;
    private int minRightWidth;
    private String text;

    public TPopupRenderer() {
        this.setLayout(new FlowLayout(0, 1, 0));
        this.leftLabel = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                if (d.width < TPopupRenderer.this.minLeftWidth) {
                    d.width = TPopupRenderer.this.minLeftWidth;
                }
                return d;
            }
        };
        this.rightLabel = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                if (d.width < TPopupRenderer.this.minRightWidth) {
                    d.width = TPopupRenderer.this.minRightWidth;
                }
                return d;
            }
        };
        this.add(this.leftLabel);
        this.add(this.rightLabel);
    }

    public void setMinLeftWidth(int width) {
        this.minLeftWidth = width;
    }

    public int getLeftWidth() {
        return this.leftLabel.getPreferredSize().width;
    }

    public void setMinRightWidth(int width) {
        this.minRightWidth = width;
    }

    public int getRightWidth() {
        return this.rightLabel.getPreferredSize().width;
    }

    public String getText() {
        return this.text;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.leftLabel.setFont(list.getFont());
        this.leftLabel.setForeground(this.getForeground());
        this.rightLabel.setFont(list.getFont());
        this.rightLabel.setForeground(this.getForeground());
        if (value instanceof ShortLongText) {
            String shortText = ((ShortLongText)value).getShortText();
            String longText = ((ShortLongText)value).getLongText();
            this.leftLabel.setText(shortText);
            this.rightLabel.setText(longText);
            this.text = (shortText == null ? "" : shortText) + "|" + (longText == null ? "" : longText);
        } else {
            this.text = value == null ? " " : value.toString();
            this.leftLabel.setText(this.text);
            this.rightLabel.setText(" ");
        }
        return this;
    }
}

