/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.text.DateFormatSymbols;
import java.util.Locale;
import org.tentackle.swing.FormComboBox;

public class MonthComboBox
extends FormComboBox<String> {
    public MonthComboBox(Locale locale) {
        this.setMaximumRowCount(12);
        this.setMultiKeySelectionManager(true);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        for (String month : new DateFormatSymbols(locale).getMonths()) {
            if (month == null || month.isEmpty()) continue;
            this.addItem(month);
        }
    }

    public MonthComboBox() {
        this((Locale)null);
    }

    public void setMonth(int month) {
        if ((month %= 12) < 0) {
            month += 12;
        }
        this.setFormValueIndex(month);
    }

    public int getMonth() {
        return this.getSelectedIndex();
    }
}

