/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.util.GregorianCalendar;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormSpinField;
import org.tentackle.swing.IntegerFormField;
import org.tentackle.swing.SpinEvent;
import org.tentackle.swing.SpinListener;

public class YearSpinField
extends FormSpinField
implements SpinListener {
    private final IntegerFormField yearField = new IntegerFormField();

    public YearSpinField(int year) {
        this.yearField.setColumns(4);
        this.setFormComponent(this.yearField);
        this.setYear(year);
        this.addSpinListener(this);
    }

    public YearSpinField() {
        this(new GregorianCalendar().get(1));
    }

    public void setYear(int year) {
        this.yearField.setIntValue(year);
    }

    public int getYear() {
        return this.yearField.getIntValue();
    }

    @Override
    public void increment(SpinEvent e, FormComponent c) {
        this.setYear(this.getYear() + 1);
    }

    @Override
    public void decrement(SpinEvent e, FormComponent c) {
        this.setYear(this.getYear() - 1);
    }
}

