/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.plaf.tmetal;

import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import org.tentackle.swing.plaf.TFlasherListener;
import org.tentackle.swing.plaf.TentackleLookAndFeel;

public class TMetalButtonUI
extends MetalButtonUI {
    private static final TMetalButtonUI tMetalButtonUI = new TMetalButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return tMetalButtonUI;
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        if (((TentackleLookAndFeel)((Object)UIManager.getLookAndFeel())).isFocusAnimated()) {
            b.addFocusListener(new TFlasherListener(b));
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        TFlasherListener.removeFlasherListener(b);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        boolean isIcon;
        Rectangle focusRect = new Rectangle();
        String text = b.getText();
        boolean bl = isIcon = b.getIcon() != null;
        if (text != null && !text.equals("")) {
            if (!isIcon) {
                focusRect.setBounds(textRect);
            } else {
                focusRect.setBounds(iconRect.union(textRect));
            }
        } else if (isIcon) {
            focusRect.setBounds(iconRect);
        }
        g.setColor(!((TentackleLookAndFeel)((Object)UIManager.getLookAndFeel())).isFocusAnimated() || TFlasherListener.isFlasherVisible() ? this.getFocusColor() : b.getBackground());
        g.drawRect(focusRect.x - 1, focusRect.y - 1, focusRect.width + 1, focusRect.height + 1);
    }
}

