/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.tentackle.common.Date;
import org.tentackle.common.Time;
import org.tentackle.common.Timestamp;
import org.tentackle.swing.DateFormField;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormCalendarDialog;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormFieldComponentPanel;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.GUIRuntimeException;
import org.tentackle.swing.SqlDateField;
import org.tentackle.swing.bind.SqlDateFieldBinding;
import org.tentackle.swing.plaf.PlafUtilities;

public class FormCalendarField
extends FormFieldComponentPanel
implements SqlDateField {
    public static final int SHOW_AUTO = -1;
    private int timeMode = -1;
    private FormButton calButton;
    private DateFormField dateField;

    public FormCalendarField() {
        super(new DateFormField());
        this.initComponents();
    }

    @Override
    public void setFormComponent(FormComponent comp) {
        throw new GUIRuntimeException("changing the component is not allowed");
    }

    @Override
    public DateFormField getFormComponent() {
        return (DateFormField)super.getFormComponent();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (name != null) {
            this.getFormComponent().setName(name + "/date");
            this.calButton.setName(name + "/calendar");
        } else {
            this.getFormComponent().setName("date");
            this.calButton.setName("calendar");
        }
    }

    public void setTimeMode(int timeMode) {
        this.timeMode = timeMode;
    }

    public int getTimeMode() {
        return this.timeMode;
    }

    public void setLenient(boolean lenient) {
        this.dateField.setLenient(lenient);
    }

    public boolean isLenient() {
        return this.dateField.isLenient();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkButtonEnabled();
    }

    @Override
    public void setChangeable(boolean changeable) {
        super.setChangeable(changeable);
        this.checkButtonEnabled();
    }

    @Override
    public void setFormValue(Object value) {
        super.setFormValue(value);
        this.checkButtonEnabled();
    }

    @Override
    public java.util.Date getFormValue() {
        return this.dateField.getFormValue();
    }

    @Override
    public Date getDate() {
        return this.dateField.getDate();
    }

    @Override
    public Timestamp getTimestamp() {
        return this.dateField.getTimestamp();
    }

    @Override
    public Time getTime() {
        return this.dateField.getTime();
    }

    public java.util.Date getReferenceDate() {
        return this.dateField.getReferenceDate();
    }

    public void setReferenceDate(java.util.Date referenceDate) {
        this.dateField.setReferenceDate(referenceDate);
    }

    public char getDefaultUnit() {
        return this.dateField.getDefaultUnit();
    }

    public void setDefaultUnit(char defaultUnit) {
        this.dateField.setDefaultUnit(defaultUnit);
    }

    public DateFormField.ReferenceDateProvider getReferenceDateProvider() {
        return this.dateField.getReferenceDateProvider();
    }

    public void setReferenceDateProvider(DateFormField.ReferenceDateProvider refProvider) {
        this.dateField.setReferenceDateProvider(refProvider);
    }

    @Override
    public void setCellEditorUsage(boolean flag) {
        super.setCellEditorUsage(flag);
        this.calButton.setFocusable(!flag);
    }

    private void checkButtonEnabled() {
        this.calButton.setEnabled(this.getFormValue() != null || this.isEnabled() && this.isChangeable());
    }

    private void initComponents() {
        this.dateField = this.getFormComponent();
        this.calButton = new FormButton();
        this.setLayout(new GridBagLayout());
        this.dateField.setName("date");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.dateField, gridBagConstraints);
        this.calButton.setIcon(PlafUtilities.getInstance().getIcon("calendar_mini"));
        this.calButton.setMargin(new Insets(0, 0, 0, 0));
        this.calButton.setName("calendar");
        this.calButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormCalendarField.this.calButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.add((Component)this.calButton, gridBagConstraints);
    }

    private void calButtonActionPerformed(ActionEvent evt) {
        int tmode = this.timeMode;
        if (tmode == -1) {
            tmode = 0;
            String fmt = this.dateField.getFormat();
            if (fmt != null && (fmt.indexOf(72) >= 0 || fmt.indexOf(75) >= 0 || fmt.indexOf(104) >= 0 || fmt.indexOf(107) >= 0)) {
                tmode = 1;
                if (fmt.indexOf(109) >= 0) {
                    tmode = 2;
                    if (fmt.indexOf(115) >= 0) {
                        tmode = 3;
                    }
                }
            }
        }
        java.util.Date date = FormCalendarDialog.createFormCalendarDialog(this, null, this.getFormValue(), tmode).showDialog();
        if (this.isChangeable() && this.isEnabled() && date != null) {
            this.setFormValue(date);
            if (!this.isCellEditorUsage() && this.isAutoUpdate()) {
                this.fireValueEntered();
            }
            this.requestFocusLater();
        }
    }

    static {
        FormUtilities.getInstance().getBindingFactory().setFormComponentBindingClass(FormCalendarField.class, SqlDateFieldBinding.class);
    }
}

