/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormComponentPanel;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.IntegerFormField;
import org.tentackle.swing.SpinEvent;
import org.tentackle.swing.SpinListener;
import org.tentackle.swing.ValueEvent;
import org.tentackle.swing.ValueListener;
import org.tentackle.swing.plaf.PlafUtilities;

public class FormSpinField
extends FormComponentPanel
implements ValueListener {
    private FormButton downButton;
    private FormButton upButton;

    public FormSpinField(FormComponent editingComponent) {
        this.initComponents();
        this.setFormComponent(editingComponent);
    }

    public FormSpinField() {
        this(new IntegerFormField());
    }

    public FormButton getUpButton() {
        return this.upButton;
    }

    public FormButton getDownButton() {
        return this.downButton;
    }

    @Override
    public void setFormComponent(FormComponent comp) {
        if (this.getFormComponent() != null) {
            this.removeValueListener(this);
            this.remove((Component)((Object)this.getFormComponent()));
        }
        super.setFormComponent(comp);
        this.addValueListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)((Object)comp), gridBagConstraints);
    }

    public synchronized void addSpinListener(SpinListener listener) {
        this.listenerList.add(SpinListener.class, listener);
    }

    public synchronized void removeSpinListener(SpinListener listener) {
        this.listenerList.remove(SpinListener.class, listener);
    }

    public void fireIncrement() {
        Object[] listeners = this.listenerList.getListenerList();
        if (listeners != null) {
            SpinEvent evt = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != SpinListener.class) continue;
                if (evt == null) {
                    evt = new SpinEvent(this, 1);
                }
                ((SpinListener)listeners[i + 1]).increment(evt, this);
            }
        }
    }

    public void fireDecrement() {
        Object[] listeners = this.listenerList.getListenerList();
        if (listeners != null) {
            SpinEvent evt = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != SpinListener.class) continue;
                if (evt == null) {
                    evt = new SpinEvent(this, 2);
                }
                ((SpinListener)listeners[i + 1]).decrement(evt, this);
            }
        }
    }

    @Override
    public void valueChanged(ValueEvent e) {
        if (this.isAutoUpdate()) {
            this.fireValueChanged();
        }
    }

    @Override
    public void valueEntered(ValueEvent e) {
        if (this.isAutoUpdate()) {
            this.fireValueEntered();
            FormUtilities.getInstance().doValidate(this);
        }
    }

    public void spinUp() {
        this.fireIncrement();
        if (this.isAutoUpdate()) {
            this.fireValueEntered();
            FormUtilities.getInstance().doValidate(this);
        }
    }

    public void spinDown() {
        this.fireDecrement();
        if (this.isAutoUpdate()) {
            this.fireValueEntered();
            FormUtilities.getInstance().doValidate(this);
        }
    }

    private void initComponents() {
        this.upButton = new FormButton();
        this.downButton = new FormButton();
        this.setLayout(new GridBagLayout());
        this.upButton.setIcon(PlafUtilities.getInstance().getIcon("spinup_mini"));
        this.upButton.setMargin(new Insets(1, 1, 1, 1));
        this.upButton.setName("up");
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormSpinField.this.upButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        this.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setIcon(PlafUtilities.getInstance().getIcon("spindown_mini"));
        this.downButton.setMargin(new Insets(1, 1, 1, 1));
        this.downButton.setName("down");
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormSpinField.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        this.add((Component)this.downButton, gridBagConstraints);
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        this.spinUp();
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        this.spinDown();
    }
}

