/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class FormTableColumnModel
extends DefaultTableColumnModel {
    protected Vector<TableColumn> originalColumns = new Vector();

    public int getOriginalIndex(TableColumn column) {
        return this.originalColumns.indexOf(column);
    }

    public int getOriginalIndex(int visibleIndex) {
        TableColumn column = super.getColumn(visibleIndex);
        int orgIndex = this.getOriginalIndex(column);
        if (orgIndex == -1) {
            throw new IllegalArgumentException("no such original column");
        }
        return orgIndex;
    }

    public TableColumn getOriginalColumn(int originalIndex) {
        return this.originalColumns.get(originalIndex);
    }

    public Enumeration<TableColumn> getOriginalColumns() {
        return this.originalColumns.elements();
    }

    public TableColumn getColumnByModelIndex(int modelIndex) {
        for (TableColumn column : this.originalColumns) {
            if (column.getModelIndex() != modelIndex) continue;
            return column;
        }
        return null;
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        super.addColumn(aColumn);
        this.originalColumns.add(aColumn);
    }

    @Override
    public void removeColumn(TableColumn column) {
        super.removeColumn(column);
        this.originalColumns.remove(column);
    }

    public void removeAllColumns() {
        while (this.tableColumns.size() > 0) {
            super.removeColumn((TableColumn)this.tableColumns.firstElement());
        }
        this.originalColumns.removeAllElements();
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        TableColumn col = this.getColumn(columnIndex);
        super.moveColumn(columnIndex, newIndex);
        if (columnIndex != newIndex) {
            this.originalColumns.remove(col);
            int viewIndex = -1;
            boolean inserted = false;
            for (int i = 0; i < this.originalColumns.size(); ++i) {
                if (!this.isOriginalColumnVisible(i) || ++viewIndex != newIndex) continue;
                this.originalColumns.insertElementAt(col, i);
                inserted = true;
                break;
            }
            if (!inserted) {
                this.originalColumns.add(col);
            }
        }
    }

    public boolean isOriginalColumnVisible(int originalIndex) {
        TableColumn column = this.originalColumns.get(originalIndex);
        return this.tableColumns.indexOf(column) >= 0;
    }

    public boolean isModelColumnVisible(int modelIndex) {
        TableColumn column = this.getColumnByModelIndex(modelIndex);
        return this.tableColumns.indexOf(column) >= 0;
    }

    public void setOriginalColumnVisible(int originalIndex, boolean visible) {
        TableColumn column = this.originalColumns.get(originalIndex);
        int visibleIndex = this.tableColumns.indexOf(column);
        if (visible) {
            if (visibleIndex == -1) {
                super.addColumn(column);
                int visibleSize = this.tableColumns.size();
                visibleIndex = 0;
                for (int orgIndex = 0; visibleIndex < visibleSize - 1 && orgIndex < originalIndex; ++orgIndex) {
                    column = this.originalColumns.get(originalIndex);
                    if (this.tableColumns.indexOf(column) < 0) continue;
                    ++visibleIndex;
                }
                if (visibleIndex < visibleSize - 1) {
                    super.moveColumn(visibleSize - 1, visibleIndex);
                }
            }
        } else if (visibleIndex >= 0) {
            super.removeColumn(column);
        }
    }

    public void setModelColumnVisible(int modelIndex, boolean visible) {
        TableColumn column = this.getColumnByModelIndex(modelIndex);
        if (column != null) {
            this.setOriginalColumnVisible(this.originalColumns.indexOf(column), visible);
        }
    }

    public void reorderColumns(int[] modelIndexes) {
        int i;
        while (this.tableColumns.size() > 0) {
            super.removeColumn((TableColumn)this.tableColumns.firstElement());
        }
        Vector<TableColumn> columns = new Vector<TableColumn>();
        for (i = 0; i < modelIndexes.length; ++i) {
            columns.add(this.getColumnByModelIndex(modelIndexes[i]));
        }
        this.originalColumns = columns;
        for (i = 0; i < this.originalColumns.size(); ++i) {
            this.setOriginalColumnVisible(i, true);
        }
    }

    public int[] getModelIndexes() {
        int[] indexes = new int[this.originalColumns.size()];
        int i = 0;
        for (TableColumn column : this.tableColumns) {
            indexes[i++] = column.getModelIndex();
        }
        for (TableColumn column : this.originalColumns) {
            if (this.tableColumns.contains(column)) continue;
            indexes[i++] = column.getModelIndex();
        }
        return indexes;
    }
}

