/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import org.tentackle.misc.Telno;
import org.tentackle.swing.FormButton;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormFieldComponentPanel;
import org.tentackle.swing.FormTelnoDialog;
import org.tentackle.swing.StringFormField;
import org.tentackle.swing.plaf.PlafUtilities;

public class FormTelnoField
extends FormFieldComponentPanel {
    public static final char UNKNOWN = '?';
    public static final char PHONE = 'P';
    public static final char FAX = 'F';
    public static final char CELL = 'C';
    public static final char MODEM = 'M';
    private int defaultCountry;
    private char telnoType;
    private int telnoNum;
    private Telno[] telnos;
    private String[] comments;
    private String[] errors;
    private String[] unparsed;
    private FormButton telnoButton;
    private StringFormField telnoField;

    public FormTelnoField() {
        this.initComponents();
        super.setFormComponent(this.telnoField);
        this.setTelnoType('?');
    }

    @Override
    public void setFormComponent(FormComponent comp) {
        throw new IllegalAccessError("changing the component is not allowed");
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (name != null) {
            ((Component)((Object)this.getFormComponent())).setName(name + "/telno");
            this.telnoButton.setName(name + "/edit");
        } else {
            ((Component)((Object)this.getFormComponent())).setName("telno");
            this.telnoButton.setName("edit");
        }
    }

    @Override
    public void setCellEditorUsage(boolean flag) {
        super.setCellEditorUsage(flag);
        this.telnoButton.setFocusable(!flag);
    }

    public void setTelnoType(char telnoType) {
        this.telnoType = telnoType;
        String iconName = "file";
        switch (telnoType) {
            case 'P': {
                iconName = "phone";
                break;
            }
            case 'F': {
                iconName = "fax";
                break;
            }
            case 'C': {
                iconName = "cellphone";
                break;
            }
            case 'M': {
                iconName = "modem";
            }
        }
        this.telnoButton.setIcon(PlafUtilities.getInstance().getIcon(iconName));
    }

    public char getTelnoType() {
        return this.telnoType;
    }

    public int getDefaultCountry() {
        return this.defaultCountry;
    }

    public void setDefaultCountry(int defaultCountry) {
        this.defaultCountry = defaultCountry;
    }

    public int getTelnoNum() {
        return this.telnoNum;
    }

    public Telno[] getTelnos() {
        return this.telnos;
    }

    public Telno getTelno(int ndx) {
        return this.telnos[ndx];
    }

    public String[] getComments() {
        return this.comments;
    }

    public String getComment(int ndx) {
        return this.comments[ndx];
    }

    private int parseTelno(String tel) {
        int errorCount = 0;
        StringTokenizer tk = null;
        if (tel == null) {
            this.telnoNum = 0;
        } else {
            tk = new StringTokenizer(tel, ",");
            this.telnoNum = tk.countTokens();
        }
        if (this.telnoNum < 1) {
            this.telnos = null;
            this.comments = null;
            this.errors = null;
            this.unparsed = null;
        } else {
            this.telnos = new Telno[this.telnoNum];
            this.comments = new String[this.telnoNum];
            this.errors = new String[this.telnoNum];
            this.unparsed = new String[this.telnoNum];
            int ndx = 0;
            while (tk.hasMoreTokens()) {
                String token = tk.nextToken();
                int len = token.length();
                StringBuilder telno = new StringBuilder(len);
                StringBuilder comment = new StringBuilder(len);
                boolean inTelno = true;
                boolean inError = false;
                for (int i = 0; i < len; ++i) {
                    char c = token.charAt(i);
                    if (c == ']') {
                        inError = false;
                        continue;
                    }
                    if (c == '[' || inError) {
                        inError = true;
                        continue;
                    }
                    if (inTelno && !Character.isDigit(c) && c != '+' && c != '-' && c != ' ') {
                        inTelno = false;
                    }
                    if (inTelno) {
                        telno.append(c);
                        continue;
                    }
                    comment.append(c);
                }
                this.unparsed[ndx] = telno.toString().trim();
                this.telnos[ndx] = new Telno();
                this.telnos[ndx].setDefaultCountry(this.defaultCountry);
                this.comments[ndx] = comment.toString().trim();
                if (!this.telnos[ndx].setTelno(this.unparsed[ndx])) {
                    this.errors[ndx] = this.telnos[ndx].getError();
                    ++errorCount;
                }
                ++ndx;
            }
        }
        return errorCount;
    }

    private void initComponents() {
        this.telnoField = new TelnoField();
        this.telnoButton = new FormButton();
        this.setLayout(new GridBagLayout());
        this.telnoField.setName("telno");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        this.add((Component)this.telnoField, gridBagConstraints);
        this.telnoButton.setMargin(new Insets(0, 0, 0, 0));
        this.telnoButton.setName("edit");
        this.telnoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormTelnoField.this.telnoButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.add((Component)this.telnoButton, gridBagConstraints);
    }

    private void telnoButtonActionPerformed(ActionEvent evt) {
        if (this.isChangeable() || this.getText() != null && this.getText().length() > 0) {
            String newTelno = FormTelnoDialog.createFormTelnoDialog(this).showDialog();
            if (this.isChangeable() && newTelno != null) {
                this.setText(newTelno);
                if (this.isAutoUpdate()) {
                    this.fireValueEntered();
                }
            }
        }
    }

    private class TelnoField
    extends StringFormField {
        private static final long serialVersionUID = -8307736594510076617L;

        private TelnoField() {
        }

        @Override
        public String getText() {
            FormTelnoField.this.parseTelno(super.getText());
            StringBuilder buf = new StringBuilder();
            int errorNdx = -1;
            for (int i = 0; i < FormTelnoField.this.telnoNum; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                if (FormTelnoField.this.errors[i] != null) {
                    buf.append(FormTelnoField.this.unparsed[i]);
                    buf.append('[');
                    buf.append(FormTelnoField.this.errors[i]);
                    buf.append(']');
                    if (errorNdx == -1) {
                        errorNdx = i;
                    }
                } else {
                    buf.append(FormTelnoField.this.telnos[i].getTelno());
                }
                if (FormTelnoField.this.comments[i].length() <= 0) continue;
                buf.append(' ');
                buf.append(FormTelnoField.this.comments[i]);
            }
            String tel = buf.toString();
            if (errorNdx >= 0) {
                super.setText(tel);
                this.errorOffset = 0;
                this.errorMessage = null;
                for (int i = 0; i < errorNdx; ++i) {
                    this.errorOffset = tel.indexOf(44, this.errorOffset) + 1;
                }
            }
            return tel;
        }
    }
}

