/**
 * Tentackle - http://www.tentackle.org
 * Copyright (C) 2001-2008 Harald Krake, harald@krake.de, +49 7722 9508-0
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */



package org.tentackle.swing;

import static org.tentackle.swing.FormTable.CELLTRAVERSAL_AUTOEDIT;
import static org.tentackle.swing.FormTable.CELLTRAVERSAL_COLUMN;
import static org.tentackle.swing.FormTable.CELLTRAVERSAL_NOLINEWRAP;
import static org.tentackle.swing.FormTable.CELLTRAVERSAL_NOTABLEWRAP;
import static org.tentackle.swing.FormTable.CELLTRAVERSAL_ROW;
import static org.tentackle.swing.FormTable.CELLTRAVERSAL_SKIPNOEDIT;
import static org.tentackle.swing.FormTable.CELLTRAVERSAL_WRAPINLINE;


/**
 * A panel to edit the formtable cell traversal.<br>
 * Used by {@link CellTraversalPropertyEditor}.
 *
 * @author harald
 */
@SuppressWarnings("serial")
public class CellTraversalPropertyEditorPanel extends javax.swing.JPanel {

  private final CellTraversalPropertyEditor editor;

  /**
   * Creates an editor panel.
   *
   * @param editor the traversal editor component
   */
  public CellTraversalPropertyEditorPanel(CellTraversalPropertyEditor editor) {
    this.editor = editor;
    initComponents();
  }

  public void setCellTraversal(int ct) {
    autoeditBox.setSelected((ct & CELLTRAVERSAL_AUTOEDIT) != 0);
    columnBox.setSelected((ct & CELLTRAVERSAL_COLUMN) != 0);
    nolinewrapBox.setSelected((ct & CELLTRAVERSAL_NOLINEWRAP) != 0);
    notablewrapBox.setSelected((ct & CELLTRAVERSAL_NOTABLEWRAP) != 0);
    rowBox.setSelected((ct & CELLTRAVERSAL_ROW) != 0);
    skipnoeditBox.setSelected((ct & CELLTRAVERSAL_SKIPNOEDIT) != 0);
    wrapinlineBox.setSelected((ct & CELLTRAVERSAL_WRAPINLINE) != 0);
  }

  public int getCellTraversal() {
    return (autoeditBox.isSelected() ? CELLTRAVERSAL_AUTOEDIT : 0) |
           (columnBox.isSelected() ? CELLTRAVERSAL_COLUMN : 0) |
           (nolinewrapBox.isSelected() ? CELLTRAVERSAL_NOLINEWRAP : 0) |
           (notablewrapBox.isSelected() ? CELLTRAVERSAL_NOTABLEWRAP : 0) |
           (rowBox.isSelected() ? CELLTRAVERSAL_ROW : 0) |
           (skipnoeditBox.isSelected() ? CELLTRAVERSAL_SKIPNOEDIT : 0) |
           (wrapinlineBox.isSelected() ? CELLTRAVERSAL_WRAPINLINE : 0);
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    columnBox = new javax.swing.JCheckBox();
    rowBox = new javax.swing.JCheckBox();
    nolinewrapBox = new javax.swing.JCheckBox();
    wrapinlineBox = new javax.swing.JCheckBox();
    notablewrapBox = new javax.swing.JCheckBox();
    skipnoeditBox = new javax.swing.JCheckBox();
    autoeditBox = new javax.swing.JCheckBox();

    setLayout(new java.awt.GridBagLayout());

    columnBox.setText("COLUMN");
    columnBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    columnBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        columnBoxActionPerformed(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
    add(columnBox, gridBagConstraints);

    rowBox.setText("ROW");
    rowBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    rowBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        rowBoxActionPerformed(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
    add(rowBox, gridBagConstraints);

    nolinewrapBox.setText("NOLINEWRAP");
    nolinewrapBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    nolinewrapBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        nolinewrapBoxActionPerformed(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 2;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
    add(nolinewrapBox, gridBagConstraints);

    wrapinlineBox.setText("WRAPINLINE");
    wrapinlineBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    wrapinlineBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        wrapinlineBoxActionPerformed(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 3;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
    add(wrapinlineBox, gridBagConstraints);

    notablewrapBox.setText("NOTABLEWRAP");
    notablewrapBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    notablewrapBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        notablewrapBoxActionPerformed(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 4;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
    add(notablewrapBox, gridBagConstraints);

    skipnoeditBox.setText("SKIPNOEDIT");
    skipnoeditBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    skipnoeditBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        skipnoeditBoxActionPerformed(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 5;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
    add(skipnoeditBox, gridBagConstraints);

    autoeditBox.setText("AUTOEDIT");
    autoeditBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
    autoeditBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        autoeditBoxActionPerformed(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 6;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
    add(autoeditBox, gridBagConstraints);
  }// </editor-fold>//GEN-END:initComponents

  private void autoeditBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_autoeditBoxActionPerformed
    editor.firePropertyChange();
  }//GEN-LAST:event_autoeditBoxActionPerformed

  private void skipnoeditBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_skipnoeditBoxActionPerformed
    editor.firePropertyChange();
  }//GEN-LAST:event_skipnoeditBoxActionPerformed

  private void notablewrapBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_notablewrapBoxActionPerformed
    editor.firePropertyChange();
  }//GEN-LAST:event_notablewrapBoxActionPerformed

  private void wrapinlineBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_wrapinlineBoxActionPerformed
    editor.firePropertyChange();
  }//GEN-LAST:event_wrapinlineBoxActionPerformed

  private void nolinewrapBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nolinewrapBoxActionPerformed
    editor.firePropertyChange();
  }//GEN-LAST:event_nolinewrapBoxActionPerformed

  private void rowBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rowBoxActionPerformed
    editor.firePropertyChange();
  }//GEN-LAST:event_rowBoxActionPerformed

  private void columnBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_columnBoxActionPerformed
    editor.firePropertyChange();
  }//GEN-LAST:event_columnBoxActionPerformed


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JCheckBox autoeditBox;
  private javax.swing.JCheckBox columnBox;
  private javax.swing.JCheckBox nolinewrapBox;
  private javax.swing.JCheckBox notablewrapBox;
  private javax.swing.JCheckBox rowBox;
  private javax.swing.JCheckBox skipnoeditBox;
  private javax.swing.JCheckBox wrapinlineBox;
  // End of variables declaration//GEN-END:variables

}
