/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing;

import java.awt.Desktop;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.tentackle.common.BMoney;
import org.tentackle.common.StringHelper;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.prefs.PersistedPreferences;
import org.tentackle.prefs.PersistedPreferencesFactory;
import org.tentackle.swing.AbstractFormTableModel;
import org.tentackle.swing.FormError;
import org.tentackle.swing.FormQuestion;
import org.tentackle.swing.FormTable;
import org.tentackle.swing.FormTableColumnModel;
import org.tentackle.swing.FormUtilities;
import org.tentackle.swing.FormWindow;
import org.tentackle.swing.SearchTextDialog;
import org.tentackle.swing.SwingSwingBundle;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FormTableUtilityPopup
implements MouseListener,
KeyListener {
    public static final String POPUP_MENU = "popupMenu";
    public static final String POPUP_COLUMN_MENU = "columnMenu";
    public static final String POPUP_COLUMN = "column";
    public static final String POPUP_COLUMN_SELECTALL = "selectAllColumns";
    public static final String POPUP_COLUMN_DESELECTALL = "deselectAllColumns";
    public static final String POPUP_SEARCH = "search";
    public static final String POPUP_PRINT = "print";
    public static final String POPUP_EXPORT_EXCEL = "exportExcel";
    public static final String POPUP_EXPORT_EXCEL_SELECTED = "exportExcelSelected";
    public static final String POPUP_EXPORT_XML = "exportXML";
    public static final String POPUP_EXPORT_XML_SELECTED = "exportXmlSelected";
    public static final String POPUP_SAVE_SYSTEM_PREFS = "saveSystemPrefs";
    public static final String POPUP_LOAD_SYSTEM_PREFS = "loadSystemPrefs";
    public static final String POPUP_SAVE_USER_PREFS = "saveUserPrefs";
    public static final String POPUP_LOAD_USER_PREFS = "loadUserPrefs";
    public static final String POPUP_LOAD_DEFAULTS = "loadDefaults";
    public static final String POPUP_AUTOWIDTH = "autoWidth";
    private static final Logger LOGGER = LoggerFactory.getLogger(FormTableUtilityPopup.class);
    private FormTable<?> table;
    private String title;
    private String intro;
    private boolean columnMenuEnabled = true;
    private String searchText;
    private boolean caseSensitive;
    private int searchKey;
    private static final String EXCEL_EXTENSION = ".xls";
    private static final String LAST_EXCEL_PREFIX = "/_lastExcelNames_";
    private static final String EXCEL_KEY = "path";
    private static final String XML_EXTENSION = ".xml";
    private static final String LAST_XML_PREFIX = "/_lastXmlNames_";
    private static final String XML_KEY = "path";

    public void setTable(FormTable<?> table) {
        this.table = table;
    }

    public FormTable<?> getTable() {
        return this.table;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setIntro(String intro) {
        this.intro = intro;
    }

    public String getIntro() {
        return this.intro;
    }

    public JPopupMenu createPopupMenu() {
        boolean someColumnSelected;
        JPopupMenu menu = new JPopupMenu();
        menu.setName(this.getClass().getName() + "/" + POPUP_MENU);
        TableColumnModel cm = this.table.getColumnModel();
        int numcol = cm.getColumnCount();
        boolean someRowSelected = this.table.getSelectedRow() >= 0;
        boolean bl = someColumnSelected = cm.getSelectionModel().getAnchorSelectionIndex() >= 0;
        if (this.columnMenuEnabled && cm instanceof FormTableColumnModel) {
            JMenu columnMenu = new JMenu();
            columnMenu.setName(POPUP_COLUMN_MENU);
            columnMenu.setText(SwingSwingBundle.getString("COLUMNS..."));
            TableModel dm = this.table.getModel();
            boolean isAbstractFormTableModel = dm instanceof AbstractFormTableModel;
            int maxcol = dm.getColumnCount();
            JCheckBoxMenuItem[] items = new JCheckBoxMenuItem[maxcol];
            for (int i = 0; i < maxcol; ++i) {
                items[i] = new JCheckBoxMenuItem(new ColumnAction(isAbstractFormTableModel ? ((AbstractFormTableModel)dm).getDisplayedColumnName(i) : dm.getColumnName(i), i));
                items[i].setName(POPUP_COLUMN + i);
                if (this.table.isColumnVisible(i)) {
                    items[i].setSelected(true);
                    items[i].setEnabled(numcol > 1);
                } else {
                    items[i].setSelected(false);
                }
                columnMenu.add(items[i]);
            }
            JRadioButtonMenuItem allItem = new JRadioButtonMenuItem(new AllColumnsAction(0, maxcol - 1, true));
            allItem.setEnabled(numcol < maxcol);
            allItem.setName(POPUP_COLUMN_SELECTALL);
            columnMenu.add(allItem);
            allItem = new JRadioButtonMenuItem(new AllColumnsAction(0, maxcol - 1, false));
            allItem.setEnabled(numcol > 1);
            allItem.setName(POPUP_COLUMN_DESELECTALL);
            columnMenu.add(allItem);
            menu.add(columnMenu);
        }
        JMenuItem autoWidthItem = new JMenuItem();
        autoWidthItem.setName(POPUP_AUTOWIDTH);
        autoWidthItem.setText(SwingSwingBundle.getString("AUTO WIDTH"));
        autoWidthItem.addActionListener(e -> this.table.autoResizeColumnWidths());
        menu.add(autoWidthItem);
        JMenuItem searchItem = new JMenuItem();
        searchItem.setName(POPUP_SEARCH);
        searchItem.setText(SwingSwingBundle.getString("SEARCH"));
        searchItem.addActionListener(e -> this.showSearchDialog());
        searchItem.setEnabled(someRowSelected && someColumnSelected);
        menu.add(searchItem);
        JMenuItem printItem = new JMenuItem();
        printItem.setName(POPUP_PRINT);
        printItem.setText(SwingSwingBundle.getString("PRINT"));
        printItem.addActionListener(e -> this.showPrintDialog());
        menu.add(printItem);
        JMenuItem excelItem = new JMenuItem();
        excelItem.setName(POPUP_EXPORT_EXCEL);
        excelItem.setText(SwingSwingBundle.getString("EXPORT TO EXCEL"));
        excelItem.addActionListener(e -> this.showExcelDialog(false));
        menu.add(excelItem);
        JMenuItem selectedExcelItem = new JMenuItem();
        selectedExcelItem.setName(POPUP_EXPORT_EXCEL_SELECTED);
        selectedExcelItem.setText(SwingSwingBundle.getString("EXPORT TO EXCEL (ONLY SELECTED)"));
        selectedExcelItem.addActionListener(e -> this.showExcelDialog(true));
        selectedExcelItem.setEnabled(someRowSelected);
        menu.add(selectedExcelItem);
        JMenuItem xmlItem = new JMenuItem();
        xmlItem.setName(POPUP_EXPORT_XML);
        xmlItem.setText(SwingSwingBundle.getString("EXPORT TO XML"));
        xmlItem.addActionListener(e -> this.showXmlDialog(false));
        menu.add(xmlItem);
        JMenuItem selectedXmlItem = new JMenuItem();
        selectedXmlItem.setName(POPUP_EXPORT_XML_SELECTED);
        selectedXmlItem.setText(SwingSwingBundle.getString("EXPORT TO XML (ONLY SELECTED)"));
        selectedXmlItem.addActionListener(e -> this.showXmlDialog(true));
        selectedXmlItem.setEnabled(someRowSelected);
        menu.add(selectedXmlItem);
        if (this.table.isCreateDefaultColumnsFromPreferences()) {
            JMenuItem restoreItem;
            JMenuItem saveItem;
            if (PersistedPreferencesFactory.getInstance().isSystemOnly()) {
                if (!PersistedPreferencesFactory.getInstance().isReadOnly()) {
                    saveItem = new JMenuItem();
                    saveItem.setName(POPUP_SAVE_SYSTEM_PREFS);
                    saveItem.setText(SwingSwingBundle.getString("SAVE SYSTEM PREFERENCES"));
                    saveItem.addActionListener(e -> {
                        if (FormQuestion.yesNo(SwingSwingBundle.getString("SAVE SYSTEM PREFERENCES FOR THIS TABLE?"))) {
                            this.saveSettings(true);
                        }
                    });
                    menu.add(saveItem);
                }
                restoreItem = new JMenuItem();
                restoreItem.setName(POPUP_LOAD_SYSTEM_PREFS);
                restoreItem.setText(SwingSwingBundle.getString("LOAD SYSTEM PREFERENCES"));
                restoreItem.addActionListener(e -> this.restoreSettings(true));
                menu.add(restoreItem);
            } else {
                if (!PersistedPreferencesFactory.getInstance().isReadOnly()) {
                    saveItem = new JMenuItem();
                    saveItem.setName(POPUP_SAVE_USER_PREFS);
                    saveItem.setText(SwingSwingBundle.getString("SAVE USER PREFERENCES"));
                    saveItem.addActionListener(e -> {
                        if (FormQuestion.yesNo(SwingSwingBundle.getString("SAVE USER PREFERENCES FOR THIS TABLE?"))) {
                            this.saveSettings(false);
                        }
                    });
                    menu.add(saveItem);
                }
                restoreItem = new JMenuItem();
                restoreItem.setName(POPUP_LOAD_USER_PREFS);
                restoreItem.setText(SwingSwingBundle.getString("LOAD USER PREFERENCES"));
                restoreItem.addActionListener(e -> this.restoreSettings(false));
                menu.add(restoreItem);
                JMenuItem restoreSysItem = new JMenuItem();
                restoreSysItem.setName(POPUP_LOAD_SYSTEM_PREFS);
                restoreSysItem.setText(SwingSwingBundle.getString("LOAD SYSTEM PREFERENCES"));
                restoreSysItem.addActionListener(e -> this.restoreSettings(true));
                menu.add(restoreSysItem);
            }
            JMenuItem defaultItem = new JMenuItem();
            defaultItem.setName(POPUP_LOAD_DEFAULTS);
            defaultItem.setText(SwingSwingBundle.getString("LOAD DEFAULT PREFERENCES"));
            defaultItem.addActionListener(e -> this.table.createDefaultColumnsFromDefaultModel());
            menu.add(defaultItem);
        }
        return menu;
    }

    public boolean isColumnMenuEnabled() {
        return this.columnMenuEnabled;
    }

    public void setColumnMenuEnabled(boolean columnMenuEnabled) {
        this.columnMenuEnabled = columnMenuEnabled;
    }

    public void saveSettings(boolean system) {
        try {
            this.table.savePreferences(this.table.getPreferencesName(), system);
        }
        catch (Exception ex) {
            FormError.showException(SwingSwingBundle.getString("COULD NOT SAVE PREFERENCES"), ex);
        }
    }

    public void restoreSettings(boolean system) {
        try {
            if (!this.table.createDefaultColumnsFromPreferences(this.table.getPreferencesName(), system) && FormQuestion.yesNo(SwingSwingBundle.getString("NO PREFERENCES FOUND. LOAD DEFAULTS?"))) {
                this.table.createDefaultColumnsFromDefaultModel();
            }
        }
        catch (Exception ex) {
            FormError.showException(SwingSwingBundle.getString("COULD NOT LOAD PREFERENCES"), ex);
        }
    }

    public boolean search(String searchText, boolean caseSensitive) {
        if (searchText != null && searchText.length() > 0) {
            String text = caseSensitive ? searchText : searchText.toUpperCase();
            int currentRow = this.table.getSelectionModel().getAnchorSelectionIndex();
            int currentCol = this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex() + 1;
            if (currentCol >= this.table.getColumnCount()) {
                ++currentRow;
                currentCol = 0;
            }
            TableModel model = this.table.getModel();
            int rows = model.getRowCount();
            int cols = model.getColumnCount();
            int startRow = currentRow;
            int endRow = rows;
            int startCol = currentCol;
            for (int part = 0; part < 2; ++part) {
                if (part == 1) {
                    startRow = 0;
                    endRow = currentRow;
                }
                for (int row = startRow; row < endRow; ++row) {
                    for (int col = startCol; col < cols; ++col) {
                        Object value = model.getValueAt(row, col);
                        if (value == null) continue;
                        String cellText = value.toString();
                        if (!caseSensitive) {
                            cellText = cellText.toUpperCase();
                        }
                        if (!cellText.contains(text)) continue;
                        this.table.setSelectedRow(row);
                        this.table.getColumnModel().getSelectionModel().setAnchorSelectionIndex(col);
                        this.table.scrollToCell(row, this.table.convertColumnIndexToView(col));
                        return true;
                    }
                    startCol = 0;
                }
            }
        }
        return false;
    }

    public void showSearchDialog() {
        SearchTextDialog sd = new SearchTextDialog();
        if (sd.showDialog(this.searchText, this.caseSensitive)) {
            this.searchText = sd.getSearchText();
            this.caseSensitive = sd.isCaseSensitive();
            this.search(this.searchText, this.caseSensitive);
        }
    }

    public void showPrintDialog() {
        this.table.clearSelection();
        try {
            this.table.print();
        }
        catch (PrinterException pe) {
            FormError.showException(SwingSwingBundle.getString("PRINTING TABLE FAILED"), pe);
        }
    }

    public void toExcel(File file, boolean onlySelected) throws IOException {
        HSSFCellStyle cs;
        HSSFRow row;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        TableModel model = this.table.getModel();
        TableColumnModel columnModel = this.table.getColumnModel();
        int[] selectedRows = onlySelected ? this.table.getSelectedRows() : new int[]{};
        int rows = onlySelected ? selectedRows.length : this.table.getRowCount();
        int cols = columnModel.getColumnCount();
        int srow = 0;
        String xTitle = this.title;
        String xIntro = this.intro;
        if (xTitle == null) {
            Window parent = FormUtilities.getInstance().getParentWindow(this.table);
            try {
                xTitle = ((FormWindow)((Object)parent)).getTitle();
            }
            catch (Exception e) {
                xTitle = null;
            }
        }
        if (xTitle != null) {
            row = sheet.createRow(srow);
            HSSFFont font = wb.createFont();
            font.setBold(true);
            cs = wb.createCellStyle();
            cs.setAlignment(HorizontalAlignment.CENTER);
            cs.setFont(font);
            HSSFCell cell = row.createCell(0);
            cell.setCellStyle(cs);
            cell.setCellValue((RichTextString)new HSSFRichTextString(xTitle));
            sheet.addMergedRegion(new CellRangeAddress(0, srow, 0, cols - 1));
            srow = (short)(srow + 1);
        }
        if (xIntro != null || onlySelected) {
            row = sheet.createRow(srow);
            HSSFCell cell = row.createCell(0);
            cs = wb.createCellStyle();
            cs.setAlignment(HorizontalAlignment.LEFT);
            cs.setVerticalAlignment(VerticalAlignment.CENTER);
            cs.setWrapText(true);
            cell.setCellStyle(cs);
            if (onlySelected) {
                xIntro = xIntro == null ? "" : xIntro + ", ";
                xIntro = xIntro + SwingSwingBundle.getString("<ONLY SELECTED ROWS>");
            }
            cell.setCellValue((RichTextString)new HSSFRichTextString(xIntro));
            sheet.addMergedRegion(new CellRangeAddress(srow, srow + 2, 0, cols - 1));
            srow = (short)(srow + 3);
        }
        boolean isAbstractFormTableModel = model instanceof AbstractFormTableModel;
        srow = (short)(srow + 1);
        HSSFRow row2 = sheet.createRow(srow);
        HSSFFont font = wb.createFont();
        font.setItalic(true);
        font.setBold(true);
        HSSFCellStyle cs2 = wb.createCellStyle();
        cs2.setAlignment(HorizontalAlignment.CENTER);
        cs2.setFont(font);
        for (int c = 0; c < cols; ++c) {
            HSSFCell cell = row2.createCell(c);
            cell.setCellValue((RichTextString)new HSSFRichTextString(isAbstractFormTableModel ? ((AbstractFormTableModel)model).getDisplayedColumnName(columnModel.getColumn(c).getModelIndex()) : model.getColumnName(columnModel.getColumn(c).getModelIndex())));
            cell.setCellStyle(cs2);
        }
        srow = (short)(srow + 1);
        HSSFCellStyle dateStyle = wb.createCellStyle();
        dateStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"m/d/yy"));
        ArrayList<HSSFCellStyle> numberStyles = new ArrayList<HSSFCellStyle>();
        HSSFDataFormat format = wb.createDataFormat();
        for (int r = 0; r < rows; ++r) {
            int modelRow = this.table.convertRowIndexToModel(onlySelected ? selectedRows[r] : r);
            row2 = sheet.createRow(srow + (short)r);
            for (int i = 0; i < cols; ++i) {
                int c = columnModel.getColumn(i).getModelIndex();
                Object value = model.getValueAt(modelRow, c);
                HSSFCell cell = row2.createCell(i);
                if (value instanceof Boolean) {
                    cell.setCellValue(((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof BMoney) {
                    BMoney money = (BMoney)value;
                    cell.setCellValue(money.doubleValue());
                    String fmt = "#,##0";
                    if (money.scale() > 0) {
                        StringBuilder buf = new StringBuilder(fmt).append('.');
                        for (int j = 0; j < money.scale(); ++j) {
                            buf.append('0');
                        }
                        fmt = buf.toString();
                    }
                    short fmtIndex = format.getFormat(fmt);
                    Iterator iter = numberStyles.iterator();
                    boolean found = false;
                    while (iter.hasNext()) {
                        cs2 = (HSSFCellStyle)iter.next();
                        if (cs2.getDataFormat() != fmtIndex) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        cs2 = wb.createCellStyle();
                        cs2.setDataFormat(fmtIndex);
                        numberStyles.add(cs2);
                    }
                    cell.setCellStyle(cs2);
                    continue;
                }
                if (value instanceof Number) {
                    cell.setCellValue(((Number)value).doubleValue());
                    continue;
                }
                if (value instanceof Date) {
                    cell.setCellValue((Date)value);
                    cell.setCellStyle(dateStyle);
                    continue;
                }
                if (value instanceof GregorianCalendar) {
                    cell.setCellValue((Calendar)((GregorianCalendar)value));
                    cell.setCellStyle(dateStyle);
                    continue;
                }
                if (value == null) continue;
                cell.setCellValue((RichTextString)new HSSFRichTextString(value.toString()));
            }
        }
        for (int c = 0; c < cols; ++c) {
            short width = (short)(columnModel.getColumn(c).getWidth() * 45);
            sheet.setColumnWidth(c, (int)width);
        }
        try (FileOutputStream fileOut = new FileOutputStream(file);){
            wb.write((OutputStream)fileOut);
        }
        try {
            LOGGER.info("launching EDIT action for {0}", new Object[]{file});
            Desktop.getDesktop().edit(file);
        }
        catch (UnsupportedOperationException ex) {
            LOGGER.info("{0} -> trying OPEN action for {1}", new Object[]{ex.getMessage(), file});
            Desktop.getDesktop().open(file);
            LOGGER.info("success!", new Object[0]);
        }
    }

    public void showExcelDialog(boolean onlySelected) {
        try {
            String prefName = LAST_EXCEL_PREFIX + this.table.getPreferencesName();
            prefName = StringHelper.trimRight((String)prefName, (char)'/');
            PersistedPreferences prefs = PersistedPreferences.userRoot().node(prefName);
            String lastName = prefs.get("path", null);
            JFileChooser jfc = new JFileChooser(lastName);
            if (lastName != null) {
                jfc.setSelectedFile(new File(lastName));
            }
            jfc.setFileSelectionMode(0);
            jfc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().toLowerCase().endsWith(FormTableUtilityPopup.EXCEL_EXTENSION) || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return SwingSwingBundle.getString("EXCEL FILE");
                }
            });
            if (jfc.showSaveDialog(null) == 0) {
                File outFile = jfc.getSelectedFile();
                if (!outFile.getName().toLowerCase().endsWith(EXCEL_EXTENSION)) {
                    outFile = new File(outFile.getPath() + EXCEL_EXTENSION);
                }
                this.toExcel(outFile, onlySelected);
                if (!PersistedPreferencesFactory.getInstance().isReadOnly()) {
                    prefs.put("path", outFile.getAbsolutePath());
                    prefs.flush();
                }
            }
        }
        catch (BackingStoreException prefName) {
        }
        catch (Exception ex) {
            FormError.showException(SwingSwingBundle.getString("COULD NOT CREATE EXCEL FILE"), ex);
        }
    }

    public void toXml(File file, boolean onlySelected) throws IOException, TransformerConfigurationException, SAXException {
        TableModel model = this.table.getModel();
        TableColumnModel columnModel = this.table.getColumnModel();
        try (PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));){
            int[] selectedRows = onlySelected ? this.table.getSelectedRows() : new int[]{};
            int rows = onlySelected ? selectedRows.length : this.table.getRowCount();
            int cols = columnModel.getColumnCount();
            StreamResult streamResult = new StreamResult(out);
            SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler hd = tf.newTransformerHandler();
            Transformer serializer = hd.getTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            hd.setResult(streamResult);
            hd.startDocument();
            AttributesImpl atts = new AttributesImpl();
            hd.startElement("", "", "FormTable", atts);
            String xTitle = this.title;
            String xIntro = this.intro;
            if (xTitle == null) {
                Window parent = FormUtilities.getInstance().getParentWindow(this.table);
                try {
                    xTitle = ((FormWindow)((Object)parent)).getTitle();
                }
                catch (Exception e) {
                    xTitle = null;
                }
            }
            if (xTitle != null) {
                hd.startElement("", "", "title", atts);
                hd.characters(xTitle.toCharArray(), 0, xTitle.length());
                hd.endElement("", "", "title");
            }
            if (xIntro != null || onlySelected) {
                if (onlySelected) {
                    xIntro = xIntro == null ? "" : xIntro + ", ";
                    xIntro = xIntro + "<only selected rows>";
                }
                hd.startElement("", "", "intro", atts);
                hd.characters(xIntro.toCharArray(), 0, xIntro.length());
                hd.endElement("", "", "intro");
            }
            boolean isAbstractFormTableModel = model instanceof AbstractFormTableModel;
            String[] tags = new String[cols];
            if (rows > 0) {
                for (int i = 0; i < cols; ++i) {
                    int c = columnModel.getColumn(i).getModelIndex();
                    tags[i] = StringHelper.toVarName((String)StringHelper.unDiacrit((String)(isAbstractFormTableModel ? ((AbstractFormTableModel)model).getDisplayedColumnName(c) : model.getColumnName(c)), (boolean)false));
                }
            }
            for (int r = 0; r < rows; ++r) {
                int modelRow = this.table.convertRowIndexToModel(onlySelected ? selectedRows[r] : r);
                hd.startElement("", "", this.table.getName(), atts);
                for (int i = 0; i < cols; ++i) {
                    int c = columnModel.getColumn(i).getModelIndex();
                    String tag = tags[i];
                    Object object = model.getValueAt(modelRow, c);
                    String value = object == null ? "" : object.toString();
                    hd.startElement("", "", tag, atts);
                    hd.characters(value.toCharArray(), 0, value.length());
                    hd.endElement("", "", tag);
                }
                hd.endElement("", "", this.table.getName());
            }
            hd.endElement("", "", "FormTable");
            hd.endDocument();
        }
        try {
            LOGGER.info("launching EDIT action for {0}", new Object[]{file});
            Desktop.getDesktop().edit(file);
        }
        catch (UnsupportedOperationException ex) {
            LOGGER.info("{0} -> trying OPEN action for {1}", new Object[]{ex.getMessage(), file});
            Desktop.getDesktop().open(file);
            LOGGER.info("success!", new Object[0]);
        }
    }

    public void showXmlDialog(boolean onlySelected) {
        try {
            String prefName = LAST_XML_PREFIX + this.table.getPreferencesName();
            prefName = StringHelper.trimRight((String)prefName, (char)'/');
            PersistedPreferences prefs = PersistedPreferences.userRoot().node(prefName);
            String lastName = prefs.get("path", null);
            JFileChooser jfc = new JFileChooser(lastName);
            if (lastName != null) {
                jfc.setSelectedFile(new File(lastName));
            }
            jfc.setFileSelectionMode(0);
            jfc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().toLowerCase().endsWith(FormTableUtilityPopup.XML_EXTENSION) || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return SwingSwingBundle.getString("XML FILE");
                }
            });
            if (jfc.showSaveDialog(null) == 0) {
                File outFile = jfc.getSelectedFile();
                if (!outFile.getName().toLowerCase().endsWith(XML_EXTENSION)) {
                    outFile = new File(outFile.getPath() + XML_EXTENSION);
                }
                this.toXml(outFile, onlySelected);
                if (!PersistedPreferencesFactory.getInstance().isReadOnly()) {
                    prefs.put("path", outFile.getAbsolutePath());
                    prefs.flush();
                }
            }
        }
        catch (BackingStoreException prefName) {
        }
        catch (Exception ex) {
            FormError.showException(SwingSwingBundle.getString("COULD NOT CREATE XML FILE"), ex);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.processTableMouseEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.processTableMouseEvent(e);
    }

    private void processTableMouseEvent(MouseEvent e) {
        if (this.table != null && e.isPopupTrigger()) {
            this.table.getTableHeader().setDraggedColumn(null);
            this.createPopupMenu().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void addKeyListenerForKey(int keyCode) {
        this.searchKey = keyCode;
        this.table.addKeyListener(this);
    }

    public void addKeyListener() {
        this.addKeyListenerForKey(114);
    }

    public void removeKeyListener() {
        this.table.removeKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == this.searchKey) {
            if (this.searchText == null) {
                this.showSearchDialog();
            } else {
                this.search(this.searchText, this.caseSensitive);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private class AllColumnsAction
    extends AbstractAction {
        private final int first;
        private final int last;
        private final boolean show;

        public AllColumnsAction(int first, int last, boolean show) {
            super(show ? SwingSwingBundle.getString("SHOW ALL") : SwingSwingBundle.getString("HIDE ALL"));
            this.first = first;
            this.last = last;
            this.show = show;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.show) {
                for (int ndx = this.first; ndx <= this.last; ++ndx) {
                    FormTableUtilityPopup.this.table.setColumnVisible(ndx, true);
                }
            } else {
                for (int ndx = this.last; ndx >= this.first; --ndx) {
                    if (FormTableUtilityPopup.this.table.getColumnModel().getColumnCount() <= 1) continue;
                    FormTableUtilityPopup.this.table.setColumnVisible(ndx, false);
                }
            }
        }
    }

    private class ColumnAction
    extends AbstractAction {
        private final int ndx;

        public ColumnAction(String text, int ndx) {
            super(text);
            this.ndx = ndx;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FormTableUtilityPopup.this.table.setColumnVisible(this.ndx, !FormTableUtilityPopup.this.table.isColumnVisible(this.ndx));
        }
    }
}

