/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.swing.bind;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.tentackle.bind.BindingException;
import org.tentackle.bind.BindingMember;
import org.tentackle.swing.FormComponent;
import org.tentackle.swing.FormFieldComponent;
import org.tentackle.swing.SqlDateField;
import org.tentackle.swing.bind.DefaultFormComponentBinding;
import org.tentackle.swing.bind.FormComponentBinder;

public class SqlDateFieldBinding
extends DefaultFormComponentBinding {
    private boolean utc;

    public SqlDateFieldBinding(FormComponentBinder binder, BindingMember[] parents, BindingMember member, FormComponent component, String componentOptions) {
        super(binder, parents, member, component, componentOptions);
    }

    @Override
    protected boolean processOption(FormFieldComponent comp, String option) {
        if ("UTC".equals(option)) {
            this.utc = true;
            return true;
        }
        return super.processOption(comp, option);
    }

    @Override
    public Object getViewValue() {
        try {
            Class type = this.getMember().getType();
            if (Timestamp.class.isAssignableFrom(type)) {
                org.tentackle.common.Timestamp timestamp = ((SqlDateField)((Object)this.getComponent())).getTimestamp();
                if (timestamp != null && this.utc) {
                    timestamp.setUTC(true);
                }
                return timestamp;
            }
            if (Time.class.isAssignableFrom(type)) {
                return ((SqlDateField)((Object)this.getComponent())).getTime();
            }
            if (Date.class.isAssignableFrom(type)) {
                return ((SqlDateField)((Object)this.getComponent())).getDate();
            }
            return super.getViewValue();
        }
        catch (Exception ex) {
            throw new BindingException("could not get component value for " + this.getMember(), (Throwable)ex);
        }
    }
}

