/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.test.fx.rdc;

import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.tentackle.common.Version;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.pdo.PdoFactory;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.test.fx.rdc.FxRdcTestApplication;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.Test;

public abstract class GuiProviderTest
extends FxRdcTestApplication {
    private final String packagePrefix;

    public GuiProviderTest(String packagePrefix) {
        super("fx-rdc-provider-test", Version.RELEASE);
        this.packagePrefix = packagePrefix;
    }

    @Test(alwaysRun=true)
    public void testGuiProviders() {
        Reflections reflections = new Reflections(this.packagePrefix, new Scanner[0]);
        reflections.getSubTypesOf(PersistentDomainObject.class).forEach(c -> {
            try {
                PersistentDomainObject pdo = PdoFactory.getInstance().create(c, this.getDomainContext());
                GuiProvider provider = GuiProviderFactory.getInstance().createGuiProvider(pdo);
                Reporter.log((String)("testing GuiProvider for PDO " + c.getName() + "<br>"));
                if (provider.editorExists()) {
                    provider.createEditor();
                }
                if (provider.finderExists()) {
                    provider.createFinder();
                }
                provider.createIcon();
                provider.createTableView();
                provider.createTreeCell();
                provider.createTreeItem();
            }
            catch (PdoRuntimeException nx) {
                if (!(nx.getCause() instanceof ClassNotFoundException)) {
                    Assert.fail((String)("creating GuiProvider for " + c.getName() + " failed"), (Throwable)nx);
                } else {
                    Reporter.log((String)("no GuiProvider for " + c.getName() + "<br>"));
                }
            }
            catch (RuntimeException ex) {
                Assert.fail((String)("Testing GuiProvider for " + c.getName() + " failed"), (Throwable)ex);
            }
        });
    }
}

