/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.testng;

import org.tentackle.common.Version;
import org.tentackle.fx.rdc.testng.FxRdcTestApplication;
import org.tentackle.fx.table.TableConfigurationProvider;
import org.tentackle.fx.table.TableConfigurationProviderFactory;
import org.tentackle.fx.table.TableConfigurationProviderService;
import org.tentackle.reflect.ClassMapper;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.Test;

public abstract class TableConfigurationProviderTest
extends FxRdcTestApplication {
    private final String packagePrefix;
    private final ClassMapper classMapper;

    public TableConfigurationProviderTest(String packagePrefix) {
        super("fx-rdc-table-config-provider-test", Version.RELEASE);
        this.packagePrefix = packagePrefix;
        this.classMapper = ClassMapper.create((String)this.getName(), TableConfigurationProvider.class);
    }

    public TableConfigurationProviderTest() {
        this(null);
    }

    @Test(alwaysRun=true)
    public void testTableConfigurationProviders() {
        for (String servicedClassName : this.classMapper.getMap().keySet()) {
            try {
                Class<?> servicedClass = Class.forName(servicedClassName);
                TableConfigurationProvider provider = TableConfigurationProviderFactory.getInstance().createTableConfigurationProvider(servicedClass);
                if (provider == null) {
                    Assert.fail((String)("no table configuration provider for " + servicedClass));
                    continue;
                }
                if (this.packagePrefix != null && !provider.getClass().getName().startsWith(this.packagePrefix)) continue;
                TableConfigurationProviderService anno = provider.getClass().getAnnotation(TableConfigurationProviderService.class);
                if (anno == null || anno.test()) {
                    Reporter.log((String)("testing table configuration provider " + provider.getClass().getName() + "<br>"), (boolean)true);
                    provider.createTableConfiguration();
                    continue;
                }
                Reporter.log((String)("table configuration provider " + provider.getClass().getName() + " not tested!<br>"), (boolean)true);
            }
            catch (ClassNotFoundException cx) {
                Assert.fail((String)("could not load provider class " + servicedClassName), (Throwable)cx);
            }
            catch (RuntimeException ex) {
                Assert.fail((String)("testing TableConfigurationProvider for " + servicedClassName + " failed"), (Throwable)ex);
            }
        }
    }
}

