/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.junit;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.tentackle.common.Version;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.fx.rdc.GuiProviderService;
import org.tentackle.fx.rdc.junit.FxRdcTestApplication;
import org.tentackle.pdo.PdoFactory;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.reflect.ClassMapper;

public abstract class GuiProviderTest
extends FxRdcTestApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiProviderTest.class);
    private final String packagePrefix;
    private final ClassMapper classMapper;

    public GuiProviderTest(String packagePrefix) {
        super("fx-rdc-provider-test", Version.RELEASE);
        this.packagePrefix = packagePrefix;
        this.classMapper = ClassMapper.create((String)this.getName(), GuiProvider.class);
    }

    public GuiProviderTest() {
        this(null);
    }

    @Test
    public void testGuiProviders() {
        for (String pdoClassName : this.classMapper.getMap().keySet()) {
            PersistentDomainObject pdo = PdoFactory.getInstance().create(pdoClassName, this.getDomainContext());
            try {
                GuiProvider provider = GuiProviderFactory.getInstance().createGuiProvider(pdo);
                if (this.packagePrefix != null && !provider.getClass().getName().startsWith(this.packagePrefix)) continue;
                GuiProviderService anno = provider.getClass().getAnnotation(GuiProviderService.class);
                if (anno == null || anno.test()) {
                    LOGGER.info(() -> "testing gui provider " + provider.getClass().getName());
                    if (provider.isEditorAvailable()) {
                        provider.createEditor();
                    }
                    if (provider.isFinderAvailable()) {
                        provider.createFinder();
                    }
                    provider.createGraphic();
                    provider.createTableView();
                    provider.createTreeItem();
                    continue;
                }
                LOGGER.info(() -> "gui provider " + provider.getClass().getName() + " not tested!");
            }
            catch (PdoRuntimeException nx) {
                if (!(nx.getCause() instanceof ClassNotFoundException)) {
                    Assertions.fail((String)("creating GuiProvider for " + pdo.getClassBaseName() + " failed"), (Throwable)nx);
                    continue;
                }
                LOGGER.info(() -> "no GuiProvider for " + pdo.getClassBaseName());
            }
            catch (RuntimeException ex) {
                Assertions.fail((String)("testing GuiProvider for " + pdo.getClassBaseName() + " failed"), (Throwable)ex);
            }
        }
    }
}

