/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.test.fx.rdc;

import org.tentackle.common.Version;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxController;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.FxFactory;
import org.tentackle.test.fx.rdc.FxRdcTestApplication;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.Test;

public abstract class ControllerTest
extends FxRdcTestApplication {
    private final String packagePrefix;

    public ControllerTest(String packagePrefix) {
        super("fx-rdc-conroller-test", Version.RELEASE);
        this.packagePrefix = packagePrefix;
    }

    public ControllerTest() {
        this(null);
    }

    @Test(alwaysRun=true)
    public void testControllers() {
        for (Class clazz : FxFactory.getInstance().getControllerClasses()) {
            if (this.packagePrefix != null && !clazz.getName().startsWith(this.packagePrefix)) continue;
            FxControllerService anno = clazz.getAnnotation(FxControllerService.class);
            if (anno == null || anno.test()) {
                Reporter.log((String)("testing controller " + clazz.getName() + "<br>"), (boolean)true);
                try {
                    FxController controller = Fx.load((Class)clazz);
                    controller.validateInjections();
                    if (anno != null && anno.binding() == FxControllerService.BINDING.NO) continue;
                    controller.getBinder().assertAllBound();
                }
                catch (RuntimeException rex) {
                    Assert.fail((String)("loading " + clazz + " failed: " + rex.getMessage()), (Throwable)rex);
                }
                continue;
            }
            Reporter.log((String)("controller " + clazz.getName() + " not tested!<br>"), (boolean)true);
        }
    }
}

