/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.test.fx.rdc;

import com.sun.javafx.application.PlatformImpl;
import java.awt.GraphicsEnvironment;
import org.tentackle.app.AbstractApplication;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxController;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.FxFactory;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionInfo;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ControllerTest
extends AbstractApplication {
    private Session session;
    private DomainContext context;

    public ControllerTest() {
        super("fx-test");
    }

    @BeforeClass(alwaysRun=true)
    public void setUpClass() throws Exception {
        SessionInfo sessionInfo = Pdo.createSessionInfo();
        this.session = Pdo.createSession((SessionInfo)sessionInfo);
        try {
            this.session.open();
        }
        catch (PersistenceException ex) {
            this.session = null;
            return;
        }
        Session.setCurrentSession((Session)this.session);
        ModificationTracker.getInstance().setSession(this.session);
        this.context = Pdo.createDomainContext((Session)this.session);
        this.register();
    }

    @AfterClass(alwaysRun=true)
    public void tearDownClass() throws Exception {
        if (this.session != null) {
            this.session.close();
            Session.setCurrentSession(null);
            this.unregister();
        }
    }

    public DomainContext getDomainContext() {
        return this.context;
    }

    public boolean isServer() {
        return false;
    }

    public <U extends PersistentDomainObject<U>> U getUser(DomainContext context, long userId) {
        return null;
    }

    @Test(alwaysRun=true)
    public void testControllers() {
        if (this.session == null) {
            Reporter.log((String)"no backend found -> no FX tests<br>");
            return;
        }
        if (GraphicsEnvironment.isHeadless()) {
            Reporter.log((String)"JVM is headless -> no FX tests<br>");
            return;
        }
        try {
            PlatformImpl.startup(() -> Reporter.log((String)"FX started<br>", (boolean)true));
        }
        catch (RuntimeException rex) {
            Reporter.log((String)"FX not supported -> no FX tests<br>");
            return;
        }
        for (Class clazz : FxFactory.getInstance().getControllerClasses()) {
            FxControllerService anno = clazz.getAnnotation(FxControllerService.class);
            if (!anno.test()) continue;
            Reporter.log((String)("testing controller " + clazz.getName() + "<br>"), (boolean)true);
            try {
                FxController controller = Fx.load((Class)clazz);
                controller.validateInjections();
                if (anno.binding() == FxControllerService.BINDING.NO) continue;
                controller.getBinder().assertAllBound();
            }
            catch (RuntimeException rex) {
                Assert.fail((String)("loading " + clazz + " failed: " + rex.getMessage()), (Throwable)rex);
            }
        }
    }
}

