/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.junit;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.tentackle.common.Version;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxController;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.rdc.junit.FxRdcTestApplication;

public abstract class ControllerTest
extends FxRdcTestApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerTest.class);
    private final String packagePrefix;

    public ControllerTest(String packagePrefix) {
        super("fx-rdc-controller-test", Version.RELEASE);
        this.packagePrefix = packagePrefix;
    }

    public ControllerTest() {
        this(null);
    }

    @Test
    public void testControllers() {
        for (Class clazz : FxFactory.getInstance().getControllerClasses()) {
            if (this.packagePrefix != null && !clazz.getName().startsWith(this.packagePrefix)) continue;
            FxControllerService anno = clazz.getAnnotation(FxControllerService.class);
            if (anno == null || anno.test()) {
                LOGGER.info(() -> "testing controller " + clazz.getName());
                try {
                    FxController controller = Fx.load((Class)clazz);
                    controller.validateInjections();
                    if (anno != null && anno.binding() == FxControllerService.BINDING.NO) continue;
                    controller.getBinder().assertAllBound();
                }
                catch (RuntimeException rex) {
                    Assertions.fail((String)("loading " + String.valueOf(clazz) + " failed: " + rex.getMessage()), (Throwable)rex);
                }
                continue;
            }
            LOGGER.info(() -> "controller " + clazz.getName() + " not tested!");
        }
    }
}

