/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.junit;

import java.awt.GraphicsEnvironment;
import javafx.application.Platform;
import org.junit.jupiter.api.BeforeAll;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.opentest4j.AssertionFailedError;
import org.tentackle.pdo.junit.TestApplication;

public abstract class FxRdcTestApplication
extends TestApplication {
    private static final String HEADLESS_MSG = "JVM is headless -> no FX tests";
    private static final Logger LOGGER = LoggerFactory.getLogger(FxRdcTestApplication.class);
    private static boolean fxStarted;

    public FxRdcTestApplication(String name, String version) {
        super(name, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeAll
    public static void startFx() {
        Class<FxRdcTestApplication> clazz = FxRdcTestApplication.class;
        synchronized (FxRdcTestApplication.class) {
            if (!fxStarted) {
                if (GraphicsEnvironment.isHeadless()) {
                    System.out.println(HEADLESS_MSG);
                    throw new AssertionFailedError(HEADLESS_MSG);
                }
                try {
                    Platform.startup(() -> LOGGER.info(() -> "FX started"));
                }
                catch (RuntimeException rex) {
                    throw new AssertionFailedError("FX not supported -> no FX tests");
                }
                fxStarted = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

