/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.testng;

import org.tentackle.common.Version;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.fx.rdc.GuiProviderService;
import org.tentackle.fx.rdc.testng.FxRdcTestApplication;
import org.tentackle.pdo.PdoFactory;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.reflect.ClassMapper;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.Test;

public abstract class GuiProviderTest
extends FxRdcTestApplication {
    private final String packagePrefix;
    private final ClassMapper classMapper;

    public GuiProviderTest(String packagePrefix) {
        super("fx-rdc-provider-test", Version.RELEASE);
        this.packagePrefix = packagePrefix;
        this.classMapper = ClassMapper.create((String)this.getName(), GuiProvider.class);
    }

    public GuiProviderTest() {
        this(null);
    }

    @Test(alwaysRun=true)
    public void testGuiProviders() {
        for (String pdoClassName : this.classMapper.getMap().keySet()) {
            PersistentDomainObject pdo = PdoFactory.getInstance().create(pdoClassName, this.getDomainContext());
            try {
                GuiProvider provider = GuiProviderFactory.getInstance().createGuiProvider(pdo);
                if (this.packagePrefix != null && !provider.getClass().getName().startsWith(this.packagePrefix)) continue;
                GuiProviderService anno = provider.getClass().getAnnotation(GuiProviderService.class);
                if (anno == null || anno.test()) {
                    Reporter.log((String)("testing gui provider " + provider.getClass().getName() + "<br>"), (boolean)true);
                    if (provider.isEditorAvailable()) {
                        provider.createEditor();
                    }
                    if (provider.isFinderAvailable()) {
                        provider.createFinder();
                    }
                    provider.createGraphic();
                    provider.createTableView();
                    provider.createTreeItem();
                    continue;
                }
                Reporter.log((String)("gui provider " + provider.getClass().getName() + " not tested!<br>"), (boolean)true);
            }
            catch (PdoRuntimeException nx) {
                if (!(nx.getCause() instanceof ClassNotFoundException)) {
                    Assert.fail((String)("creating GuiProvider for " + pdo.getClassBaseName() + " failed"), (Throwable)nx);
                    continue;
                }
                Reporter.log((String)("no GuiProvider for " + pdo.getClassBaseName() + "<br>"), (boolean)true);
            }
            catch (RuntimeException ex) {
                Assert.fail((String)("testing GuiProvider for " + pdo.getClassBaseName() + " failed"), (Throwable)ex);
            }
        }
    }
}

