/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.junit;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.tentackle.common.Version;
import org.tentackle.fx.rdc.junit.FxRdcTestApplication;
import org.tentackle.fx.table.TableConfigurationProvider;
import org.tentackle.fx.table.TableConfigurationProviderFactory;
import org.tentackle.fx.table.TableConfigurationProviderService;
import org.tentackle.reflect.ClassMapper;

public abstract class TableConfigurationProviderTest
extends FxRdcTestApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableConfigurationProviderTest.class);
    private final String packagePrefix;
    private final ClassMapper classMapper;

    public TableConfigurationProviderTest(String packagePrefix) {
        super("fx-rdc-table-config-provider-test", Version.RELEASE);
        this.packagePrefix = packagePrefix;
        this.classMapper = ClassMapper.create((String)this.getName(), TableConfigurationProvider.class);
    }

    public TableConfigurationProviderTest() {
        this(null);
    }

    @Test
    public void testTableConfigurationProviders() {
        for (String servicedClassName : this.classMapper.getMap().keySet()) {
            try {
                Class<?> servicedClass = Class.forName(servicedClassName);
                TableConfigurationProvider provider = TableConfigurationProviderFactory.getInstance().createTableConfigurationProvider(servicedClass);
                if (provider == null) {
                    Assertions.fail((String)("no table configuration provider for " + String.valueOf(servicedClass)));
                    continue;
                }
                if (this.packagePrefix != null && !provider.getClass().getName().startsWith(this.packagePrefix)) continue;
                TableConfigurationProviderService anno = provider.getClass().getAnnotation(TableConfigurationProviderService.class);
                if (anno == null || anno.test()) {
                    LOGGER.info(() -> "testing table configuration provider " + provider.getClass().getName());
                    provider.createTableConfiguration();
                    continue;
                }
                LOGGER.info(() -> "table configuration provider " + provider.getClass().getName() + " not tested");
            }
            catch (ClassNotFoundException cx) {
                Assertions.fail((String)("could not load provider class " + servicedClassName), (Throwable)cx);
            }
            catch (RuntimeException ex) {
                Assertions.fail((String)("testing TableConfigurationProvider for " + servicedClassName + " failed"), (Throwable)ex);
            }
        }
    }
}

