/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.test.pdo.mock;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.Timestamp;
import org.tentackle.log.Logger;
import org.tentackle.misc.IdSerialTuple;
import org.tentackle.misc.IdentifiableMap;
import org.tentackle.misc.ImmutableException;
import org.tentackle.misc.ScrollableResource;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainDelegate;
import org.tentackle.pdo.PdoCache;
import org.tentackle.pdo.PdoMethodCache;
import org.tentackle.pdo.PdoMethodCacheProvider;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.PersistentObject;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityResult;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationScope;

public class MockPersistentObject<T extends PersistentDomainObject<T>, P extends MockPersistentObject<T, P>>
implements PersistentObject<T>,
PdoMethodCacheProvider<T> {
    private static final String UNSUPPORTED = "not implemented";
    private static final Map<Class, PdoMethodCache> METHOD_CACHE_MAP = new ConcurrentHashMap<Class, PdoMethodCache>();
    private DomainContext context;
    private T pdo;
    private transient Session session;
    private transient boolean sessionImmutable;
    private boolean immutable;
    private boolean finallyImmutable;
    private long id;
    private long serial;
    private long tableSerial;
    private long rootId;
    private int rootClassId;

    public MockPersistentObject(T pdo, DomainContext context) {
        this.pdo = pdo;
        this.context = context;
        this.session = context == null ? null : context.getSession();
    }

    public MockPersistentObject(T pdo, Session session) {
        this.pdo = pdo;
        this.session = session;
    }

    public MockPersistentObject(T pdo) {
        this.pdo = pdo;
    }

    public MockPersistentObject() {
    }

    public T getPdo() {
        return this.pdo;
    }

    public T me() {
        return this.pdo;
    }

    public void setPdo(T pdo) {
        this.pdo = pdo;
    }

    public PdoMethodCache<T> getPdoMethodCache() {
        return METHOD_CACHE_MAP.computeIfAbsent(this.getClass(), clazz -> new PdoMethodCache(clazz));
    }

    public void setSessionImmutable(boolean sessionImmutable) {
        this.sessionImmutable = sessionImmutable;
    }

    public boolean isSessionImmutable() {
        return this.sessionImmutable;
    }

    public void setSession(Session session) {
        if (this.isSessionImmutable() && this.session != session) {
            throw new PersistenceException(this.session, "illegal attempt to change the immutable session of " + this + " from " + this.session + " to " + session);
        }
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id < 0L ? -this.id : this.id;
    }

    public void setSerial(long serial) {
        this.serial = serial;
    }

    public long getSerial() {
        return this.serial;
    }

    public void setTableSerial(long tableSerial) {
        this.tableSerial = tableSerial;
    }

    public long getTableSerial() {
        return this.tableSerial;
    }

    public String getTableName() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public String getClassBaseName() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public int getClassId() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public SecurityResult getSecurityResult(Permission permission) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isPermissionAccepted(Permission permission) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isNew() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public void reserveId() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public void reserveId(long id) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isDeleted() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isVirgin() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public void setModified(boolean modified) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isTracked() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isModified() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean attributesModified() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean differsPersisted() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isPersistable() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isReferenced() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public void setExpired(boolean expired) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isExpired() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public List<IdSerialTuple> getExpiredTableSerials(long oldSerial, long maxSerial) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public List<IdSerialTuple> selectExpiredTableSerials(long oldSerial) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public List<IdSerialTuple> selectExpiredTableSerials(long oldSerial, long maxSerial) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public PdoCache<T> getCache() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public long getCacheAccessTime() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public long getCacheAccessCount() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public void markCacheAccess() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isCached() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isCacheable() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isRemovable() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public void delete() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean containsPattern(String pattern) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public T findDuplicate() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public long getTokenLockTimeout() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public T select(long id) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public T selectForUpdate(long id) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public T reload() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public T reloadForUpdate() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public List<T> selectAll() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public T selectCached(long id) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public List<T> selectAllCached() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public void save() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public T persist() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public Object getTransientData() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public void setTransientData(Object data) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public long getEditedBy() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public void setEditedBy(long editedBy) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isTokenLocked() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isTokenLockedBy(long userId) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isTokenLockedByMe() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isTokenLockableByMe() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public Timestamp getEditedSince() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public void setEditedSince(Timestamp editedSince) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public Timestamp getEditedExpiry() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public void setEditedExpiry(Timestamp editedExpiry) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public <U extends PersistentDomainObject<U>> U getTokenLockObject() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public <U extends PersistentDomainObject<U>> void setTokenLockObject(U obj) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public List<ValidationResult> validate(String validationPath, ValidationScope scope) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public String toGenericString() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public Class<? extends ValidationScope>[] getDefaultScopes() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public DomainContext getDomainContext() {
        return this.context;
    }

    public void setDomainContext(DomainContext context) {
        this.context = context;
    }

    public void determineContextId() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public long getContextId() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public DomainContext getBaseContext() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public DomainContext createValidContext() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public void setImmutable(boolean immutable) {
        if (!immutable && this.finallyImmutable) {
            throw new ImmutableException("object is finally immutable");
        }
        this.immutable = immutable;
    }

    public void setFinallyImmutable() {
        this.setImmutable(true);
        this.finallyImmutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public boolean isFinallyImmutable() {
        return this.finallyImmutable;
    }

    public void setImmutableLoggingLevel(Logger.Level immutableLoggingLevel) {
    }

    public Logger.Level getImmutableLoggingLevel() {
        return null;
    }

    public boolean isRootEntity() {
        return false;
    }

    public <C extends PersistentDomainObject<C>> boolean isRootEntityOf(C component) {
        return this.isRootEntity() && component != null && component.getRootId() == this.getId() && component.getRootClassId() == this.getClassId();
    }

    public boolean isComposite() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isDomainContextImmutable() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public void setDomainContextImmutable(boolean contextImmutable) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public T createSnapshot() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public void revertToSnapshot(T snapshot) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isSnapshot() {
        return false;
    }

    public List<T> getSnapshots() {
        return Collections.emptyList();
    }

    public void discardSnapshot(T snapshot) {
    }

    public void discardSnapshots() {
    }

    public void setNormText(String normText) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public String getNormText() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public ScrollableResource<T> selectAllAsCursor() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public List<T> selectByNormText(String normText) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public long getModificationCount() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public List<T> selectAllForCache() {
        return this.selectAll();
    }

    public T selectCachedOnly(long id) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public ScrollableResource<T> selectByNormTextAsCursor(String normText) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public IdentifiableMap<? extends PersistentDomainObject<?>> loadComponents(boolean onlyLoaded) {
        return new IdentifiableMap();
    }

    public T copy() {
        return null;
    }

    public boolean isCopy() {
        return false;
    }

    public void setCopy(boolean copy) {
    }

    public List<IdSerialTuple> selectAllIdSerial() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public long selectSerial(long id) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public long selectMaxId() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public long selectMaxTableSerial() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isAbstract() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isWriteAllowed() {
        return true;
    }

    public boolean isTableSerialProvided() {
        return false;
    }

    public boolean isTokenLockProvided() {
        return false;
    }

    public boolean isNormTextProvided() {
        return false;
    }

    public long getRootId() {
        return this.rootId;
    }

    public void setRootId(long rootId) {
        this.rootId = rootId;
    }

    public int getRootClassId() {
        return this.rootClassId;
    }

    public void setRootClassId(int rootClassId) {
        this.rootClassId = rootClassId;
    }

    public boolean isRootIdProvided() {
        return false;
    }

    public boolean isRootClassIdProvided() {
        return false;
    }

    public void validate() {
    }

    public void requestTokenLock() {
    }

    public void releaseTokenLock() {
    }

    public T persistTokenLocked() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public DomainDelegate<T> getDomainDelegate() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public T selectForCache(long id) {
        return this.select(id);
    }

    public T transferTokenLock(long userId) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isViewAllowed() {
        return true;
    }

    public boolean isEditAllowed() {
        return true;
    }

    public boolean isValidated() {
        return !this.isModified();
    }

    public String toIdString() {
        return this.getClassId() + ":" + this.getId();
    }

    public List<T> selectAllWithExpiredTableSerials(long oldSerial) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }
}

