/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.test.pdo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextProvider;
import org.tentackle.pdo.Pdo;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

public abstract class AbstractPdoTest
implements DomainContextProvider {
    private static Session session;
    private static DomainContext context;
    private final TransactionType txType;
    private final boolean commit;
    private long txVoucher;

    public AbstractPdoTest(TransactionType txType, boolean commit) {
        this.txType = txType;
        this.commit = commit;
    }

    public AbstractPdoTest(TransactionType txType) {
        this(txType, false);
    }

    public AbstractPdoTest() {
        this(TransactionType.CLASS, false);
    }

    @BeforeSuite(alwaysRun=true)
    public void openSessionsAndStartModificationTracker() throws Exception {
        session = this.openSession();
        context = this.createDomainContext();
        ModificationTracker tracker = ModificationTracker.getInstance();
        tracker.setSession(session.clone(null));
        tracker.setSleepInterval(500L);
        tracker.start();
    }

    @AfterSuite(alwaysRun=true)
    public void closeSessionsAndTerminateModificationTracker() throws Exception {
        if (session != null) {
            ModificationTracker.getInstance().terminate();
            session.close();
        }
    }

    @BeforeClass(alwaysRun=true)
    public void beforeClass() throws Exception {
        if (this.txType == TransactionType.CLASS) {
            this.beginTransaction();
        }
    }

    @AfterClass(alwaysRun=true)
    public void afterClass() throws Exception {
        if (this.txType == TransactionType.CLASS) {
            this.endTransaction();
        }
    }

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod() throws Exception {
        if (this.txType == TransactionType.METHOD) {
            this.beginTransaction();
        }
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws Exception {
        if (this.txType == TransactionType.METHOD) {
            this.endTransaction();
        }
    }

    public Session getSession() {
        return session;
    }

    public boolean isCommit() {
        return this.commit;
    }

    public DomainContext getDomainContext() {
        return context;
    }

    public int runInOtherJVM(Class<?> testClass) throws IOException {
        Process process = AbstractPdoTest.runClass(testClass, new String[0]);
        AbstractPdoTest.waitForProcess(process);
        return process.exitValue();
    }

    protected Session openSession() {
        Session s;
        try {
            s = Pdo.createSession();
        }
        catch (PersistenceException ex) {
            throw new SkipException("no backend found -> no tests", (Throwable)ex);
        }
        s.makeCurrent();
        return s;
    }

    protected DomainContext createDomainContext() {
        return Pdo.createDomainContext();
    }

    protected void beginTransaction() {
        if (session != null) {
            this.txVoucher = session.begin("test");
        }
    }

    protected void endTransaction() {
        if (session != null && session.isTxRunning()) {
            if (this.commit) {
                session.commit(this.txVoucher);
            } else {
                session.rollback(this.txVoucher);
            }
            this.txVoucher = 0L;
        }
    }

    public static Process runClass(Class<?> testClass, String ... args) throws IOException {
        String javaHome = System.getProperty("java.home");
        Object classPath = System.getProperty("java.class.path");
        String modulePath = System.getProperty("jdk.module.path");
        if (modulePath != null) {
            if (!((String)classPath).endsWith(":")) {
                classPath = (String)classPath + ":";
            }
            classPath = (String)classPath + modulePath;
        }
        StringBuilder cmd = new StringBuilder();
        cmd.append(javaHome).append("/bin/java -cp ").append((String)classPath).append(' ').append(testClass.getName());
        if (args != null) {
            for (String arg : args) {
                cmd.append(' ').append(arg);
            }
        }
        Reporter.log((String)("running: " + cmd + "<br>"));
        return Runtime.getRuntime().exec(cmd.toString());
    }

    public static void waitForProcess(Process process) throws IOException {
        String line;
        try {
            process.waitFor();
        }
        catch (InterruptedException ex) {
            Assert.fail((String)("executing " + process + " failed<br>"), (Throwable)ex);
        }
        InputStreamReader r = new InputStreamReader(process.getInputStream());
        try (BufferedReader in = new BufferedReader(r);){
            while ((line = in.readLine()) != null) {
                Reporter.log((String)(line + "<br>"));
            }
        }
        r = new InputStreamReader(process.getErrorStream());
        in = new BufferedReader(r);
        try {
            while ((line = in.readLine()) != null) {
                Reporter.log((String)(line + "<br>"));
            }
        }
        finally {
            in.close();
        }
    }

    public static enum TransactionType {
        CLASS,
        METHOD,
        NONE;

    }
}

