/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.pdo.junit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Set;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.opentest4j.AssertionFailedError;
import org.tentackle.dbms.Db;
import org.tentackle.model.ModelException;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextProvider;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.test.DbTestUtilities;
import org.tentackle.script.ScriptFactory;
import org.tentackle.script.ScriptingLanguage;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.sql.Backend;
import org.testng.Reporter;

public abstract class AbstractPdoTest
implements DomainContextProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPdoTest.class);
    private static Session session;
    private static DomainContext context;
    private static AbstractPdoTest currentTest;
    private final boolean closeIt;
    private final TransactionType txType;
    private final boolean commit;
    private long txVoucher;

    public AbstractPdoTest(TransactionType txType, boolean commit) {
        this.txType = txType;
        this.commit = commit;
        this.closeIt = this.openSessionsAndStartModificationTracker();
        if (txType == TransactionType.CLASS) {
            this.beginTransaction();
        }
    }

    public AbstractPdoTest(TransactionType txType) {
        this(txType, false);
    }

    public AbstractPdoTest() {
        this(TransactionType.CLASS, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openSessionsAndStartModificationTracker() {
        Class<AbstractPdoTest> clazz = AbstractPdoTest.class;
        synchronized (AbstractPdoTest.class) {
            if (currentTest != null) {
                throw new AssertionFailedError("another AbstractPdoTest is currently running: " + currentTest.getClass().getName());
            }
            currentTest = this;
            if (session == null) {
                Set languages;
                Db db;
                Backend backend;
                session = this.openSession();
                context = this.createDomainContext();
                boolean populate = false;
                Session session = AbstractPdoTest.session;
                if (session instanceof Db && (backend = (db = (Db)session).getBackend()).isDatabaseInMemory(AbstractPdoTest.session.getUrl())) {
                    this.createDatabaseTables(db);
                    populate = true;
                }
                if (ScriptFactory.getInstance().getDefaultLanguage() == null && (languages = ScriptFactory.getInstance().getLanguages()).size() == 1) {
                    ScriptFactory.getInstance().setDefaultLanguage((ScriptingLanguage)languages.iterator().next());
                }
                ModificationTracker tracker = ModificationTracker.getInstance();
                tracker.setSession(AbstractPdoTest.session.clone(null));
                tracker.setSleepInterval(500L);
                tracker.start();
                if (populate) {
                    this.populateDatabase();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    @AfterAll
    public static synchronized void closeSessionsAndTerminateModificationTracker() {
        if (currentTest != null) {
            if (AbstractPdoTest.currentTest.txType == TransactionType.CLASS) {
                currentTest.endTransaction();
            }
            if (AbstractPdoTest.currentTest.closeIt && session != null) {
                ModificationTracker.getInstance().terminate();
                session.close();
                session = null;
                context = null;
            }
            currentTest = null;
        }
    }

    @BeforeEach
    public void beforeMethod() throws Exception {
        if (this.txType == TransactionType.METHOD) {
            this.beginTransaction();
        }
    }

    @AfterEach
    public void afterMethod() throws Exception {
        if (this.txType == TransactionType.METHOD) {
            this.endTransaction();
        }
    }

    public Session getSession() {
        return session;
    }

    public boolean isCommit() {
        return this.commit;
    }

    public DomainContext getDomainContext() {
        return context;
    }

    public int runInOtherJVM(Class<?> testClass) throws IOException {
        Process process = AbstractPdoTest.runClass(testClass, new String[0]);
        AbstractPdoTest.waitForProcess(process);
        return process.exitValue();
    }

    protected Session openSession() {
        Session s;
        try {
            s = Pdo.createSession();
        }
        catch (PersistenceException ex) {
            throw new AssertionFailedError("no backend found -> no tests", (Throwable)ex);
        }
        s.makeCurrent();
        return s;
    }

    protected void createDatabaseTables(Db db) {
        try {
            String script = DbTestUtilities.getInstance().createPopulateScript(db);
            DbTestUtilities.getInstance().runScript(db, script);
        }
        catch (ModelException e) {
            throw new AssertionFailedError("populating the database failed", (Throwable)e);
        }
    }

    protected void populateDatabase() {
    }

    protected DomainContext createDomainContext() {
        return Pdo.createDomainContext();
    }

    protected void beginTransaction() {
        if (session != null) {
            this.txVoucher = session.begin("test");
        }
    }

    protected void endTransaction() {
        if (session != null && session.isTxRunning()) {
            if (this.commit) {
                session.commit(this.txVoucher);
            } else {
                session.rollback(this.txVoucher);
            }
            this.txVoucher = 0L;
        }
    }

    public static Process runClass(Class<?> testClass, String ... args) throws IOException {
        String javaHome = System.getProperty("java.home");
        Object classPath = System.getProperty("java.class.path");
        String modulePath = System.getProperty("jdk.module.path");
        if (modulePath != null) {
            if (!((String)classPath).endsWith(":")) {
                classPath = (String)classPath + ":";
            }
            classPath = (String)classPath + modulePath;
        }
        Object[] cmd = new String[]{javaHome + File.separator + "bin" + File.separator + "java", "-cp", classPath, testClass.getName()};
        if (args != null && args.length > 0) {
            String[] aCmd = (String[])Arrays.copyOf(cmd, cmd.length + args.length);
            System.arraycopy(args, 0, aCmd, cmd.length, args.length);
            cmd = aCmd;
        }
        Reporter.log((String)("running: " + Arrays.toString(cmd) + "<br>"));
        return Runtime.getRuntime().exec((String[])cmd);
    }

    public static void waitForProcess(Process process) throws IOException {
        String msg;
        String line;
        try {
            process.waitFor();
        }
        catch (InterruptedException ex) {
            throw new AssertionFailedError("executing " + process + " failed", (Throwable)ex);
        }
        InputStreamReader r = new InputStreamReader(process.getInputStream());
        try (BufferedReader in = new BufferedReader(r);){
            while ((line = in.readLine()) != null) {
                msg = line;
                LOGGER.info(() -> msg);
            }
        }
        r = new InputStreamReader(process.getErrorStream());
        in = new BufferedReader(r);
        try {
            while ((line = in.readLine()) != null) {
                msg = line;
                LOGGER.info(() -> msg);
            }
        }
        finally {
            in.close();
        }
    }

    public static enum TransactionType {
        CLASS,
        METHOD,
        NONE;

    }
}

