/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.pdo.test;

import java.util.Collection;
import java.util.HashSet;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.dbms.Db;
import org.tentackle.model.Entity;
import org.tentackle.model.EntityInfo;
import org.tentackle.model.ForeignKey;
import org.tentackle.model.Index;
import org.tentackle.model.Model;
import org.tentackle.model.ModelException;
import org.tentackle.pdo.test.DbTestUtilitiesHolder;
import org.tentackle.sql.Backend;

@Service(value=DbTestUtilities.class)
public class DbTestUtilities {
    public static DbTestUtilities getInstance() {
        return DbTestUtilitiesHolder.INSTANCE;
    }

    public String createPopulateScript(Db db) throws ModelException {
        Backend backend = db.getBackend();
        StringBuilder script = new StringBuilder();
        if (backend.isSequenceSupported()) {
            script.append(backend.sqlCreateSequence("object_sequence_id", Long.valueOf(1L), Long.valueOf(1L))).append(backend.getStatementSeparator()).append('\n');
        }
        Model model = Model.getInstance();
        HashSet<String> schemas = new HashSet<String>();
        for (EntityInfo entityInfo : model.loadFromResources(true)) {
            Entity entity = entityInfo.getEntity();
            if (entity.getTableProvidingEntity() != entity || entity.getOptions().isProvided()) continue;
            String schema = entity.getSchemaName();
            if (!StringHelper.isAllWhitespace((String)schema) && schemas.add(schema)) {
                script.append(backend.sqlCreateSchema(schema)).append(backend.getStatementSeparator()).append('\n');
            }
            script.append(entity.sqlCreateTable(backend));
            for (Index index : entity.getTableIndexes()) {
                script.append(index.sqlCreateIndex(backend, entity));
            }
        }
        Collection foreignKeys = model.getForeignKeys();
        if (!foreignKeys.isEmpty()) {
            for (ForeignKey foreignKey : foreignKeys) {
                script.append(foreignKey.sqlCreateForeignKey(backend));
            }
        }
        return script.toString();
    }

    public void runScript(Db db, String script) {
        db.runScript("populate", script);
    }
}

