/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.pdo.mock;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainDelegate;
import org.tentackle.pdo.Operation;
import org.tentackle.pdo.OperationMethodCache;
import org.tentackle.pdo.OperationMethodCacheProvider;
import org.tentackle.pdo.PersistentOperation;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;

public class MockPersistentOperation<T extends Operation<T>>
implements PersistentOperation<T>,
OperationMethodCacheProvider<T> {
    private static final long serialVersionUID = 1L;
    private static final String UNSUPPORTED = "not implemented";
    private static final Map<Class, OperationMethodCache> METHOD_CACHE_MAP = new ConcurrentHashMap<Class, OperationMethodCache>();
    private DomainContext context;
    private T operation;
    private transient Session session;
    private transient boolean sessionImmutable;

    public MockPersistentOperation(T operation, DomainContext context) {
        this.operation = operation;
        this.context = context;
        this.session = context == null ? null : context.getSession();
    }

    public MockPersistentOperation(T operation, Session session) {
        this.operation = operation;
        this.session = session;
    }

    public MockPersistentOperation(T operation) {
        this.operation = operation;
    }

    public MockPersistentOperation() {
    }

    public OperationMethodCache<T> getOperationMethodCache() {
        return METHOD_CACHE_MAP.computeIfAbsent(this.getClass(), OperationMethodCache::new);
    }

    public void setSessionImmutable(boolean sessionImmutable) {
        this.sessionImmutable = sessionImmutable;
    }

    public boolean isSessionImmutable() {
        return this.sessionImmutable;
    }

    public void setSession(Session session) {
        if (this.isSessionImmutable() && this.session != session) {
            throw new PersistenceException(this.session, "illegal attempt to change the immutable session of " + this + " from " + this.session + " to " + session);
        }
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public DomainContext getDomainContext() {
        return this.context;
    }

    public void setDomainContext(DomainContext context) {
        this.context = context;
    }

    public void determineContextId() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public long getContextId() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public DomainContext getBaseContext() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public DomainContext createValidContext() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public boolean isDomainContextImmutable() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public void setDomainContextImmutable(boolean contextImmutable) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    public T getOperation() {
        return this.operation;
    }

    public T me() {
        return this.operation;
    }

    public void setOperation(T operation) {
        this.operation = operation;
    }

    public DomainDelegate<T> getDomainDelegate() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }
}

