/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.pdo.junit;

import java.util.Properties;
import org.junit.jupiter.api.AfterAll;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.TestAbortedException;
import org.tentackle.app.AbstractApplication;
import org.tentackle.dbms.Db;
import org.tentackle.misc.Identifiable;
import org.tentackle.model.ModelException;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.test.DbTestUtilities;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionInfo;
import org.tentackle.sql.Backend;

public abstract class TestApplication
extends AbstractApplication {
    private static TestApplication application;

    @AfterAll
    public static synchronized void tearDownClass() {
        if (application != null) {
            Session session = application.getSession();
            if (session != null) {
                session.close();
                Session.setCurrentSession(null);
                application.unregister();
            }
            application = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestApplication(String name, String version) {
        super(name, version);
        Class<TestApplication> clazz = TestApplication.class;
        synchronized (TestApplication.class) {
            Db db;
            Backend backend;
            Session session;
            if (application != null) {
                throw new AssertionFailedError("another TestApplication is still running: " + ((Object)((Object)application)).getClass().getName());
            }
            application = this;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            SessionInfo sessionInfo = Pdo.createSessionInfo();
            sessionInfo.applyProperties();
            try {
                session = Pdo.createSession((SessionInfo)sessionInfo);
            }
            catch (PersistenceException ex) {
                throw new TestAbortedException("no backend found -> no tests", (Throwable)ex);
            }
            Session.setCurrentSession((Session)session);
            boolean populate = false;
            if (session instanceof Db && (backend = (db = (Db)session).getBackend()).isDatabaseInMemory(session.getUrl())) {
                this.createDatabaseTables(db);
                populate = true;
            }
            if (this.getProperties() == null) {
                this.setProperties(new Properties());
            }
            this.applyProperties(sessionInfo.getProperties());
            if (!this.getProperties().containsKey("notracker")) {
                ModificationTracker.getInstance().setSession(session);
            }
            this.setDomainContext(Pdo.createDomainContext((Session)session));
            this.register();
            this.initializeScripting();
            if (populate) {
                this.populateDatabase();
            }
            return;
        }
    }

    protected void startup() {
    }

    public <U extends Identifiable> U getUser(DomainContext context, long userId) {
        return null;
    }

    protected void createDatabaseTables(Db db) {
        try {
            String script = DbTestUtilities.getInstance().createPopulateScript(db);
            DbTestUtilities.getInstance().runScript(db, script);
        }
        catch (ModelException e) {
            throw new AssertionFailedError("populating the database failed", (Throwable)e);
        }
    }

    protected void populateDatabase() {
    }
}

