/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.pdo.testng;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Set;
import org.tentackle.dbms.Db;
import org.tentackle.model.ModelException;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextProvider;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.test.DbTestUtilities;
import org.tentackle.script.ScriptFactory;
import org.tentackle.script.ScriptingLanguage;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.sql.Backend;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

public abstract class AbstractPdoTest
implements DomainContextProvider {
    private static Session session;
    private static DomainContext context;
    private final TransactionType txType;
    private final boolean commit;
    private long txVoucher;

    public AbstractPdoTest(TransactionType txType, boolean commit) {
        this.txType = txType;
        this.commit = commit;
    }

    public AbstractPdoTest(TransactionType txType) {
        this(txType, false);
    }

    public AbstractPdoTest() {
        this(TransactionType.CLASS, false);
    }

    @BeforeSuite(alwaysRun=true)
    public void openSessionsAndStartModificationTracker() throws Exception {
        Set languages;
        Db db;
        Backend backend;
        session = this.openSession();
        context = this.createDomainContext();
        boolean populate = false;
        Session session = AbstractPdoTest.session;
        if (session instanceof Db && (backend = (db = (Db)session).getBackend()).isDatabaseInMemory(AbstractPdoTest.session.getUrl())) {
            this.createDatabaseTables(db);
            populate = true;
        }
        if (ScriptFactory.getInstance().getDefaultLanguage() == null && (languages = ScriptFactory.getInstance().getLanguages()).size() == 1) {
            ScriptFactory.getInstance().setDefaultLanguage((ScriptingLanguage)languages.iterator().next());
        }
        ModificationTracker tracker = ModificationTracker.getInstance();
        tracker.setSession(AbstractPdoTest.session.clone(null));
        tracker.setSleepInterval(500L);
        tracker.start();
        if (populate) {
            this.populateDatabase();
        }
    }

    @AfterSuite(alwaysRun=true)
    public void closeSessionsAndTerminateModificationTracker() throws Exception {
        if (session != null) {
            ModificationTracker.getInstance().terminate();
            session.close();
        }
    }

    @BeforeClass(alwaysRun=true)
    public void beforeClass() throws Exception {
        if (this.txType == TransactionType.CLASS) {
            this.beginTransaction();
        }
    }

    @AfterClass(alwaysRun=true)
    public void afterClass() throws Exception {
        if (this.txType == TransactionType.CLASS) {
            this.endTransaction();
        }
    }

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod() throws Exception {
        if (this.txType == TransactionType.METHOD) {
            this.beginTransaction();
        }
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() throws Exception {
        if (this.txType == TransactionType.METHOD) {
            this.endTransaction();
        }
    }

    public Session getSession() {
        return session;
    }

    public boolean isCommit() {
        return this.commit;
    }

    public DomainContext getDomainContext() {
        return context;
    }

    public int runInOtherJVM(Class<?> testClass) throws IOException {
        Process process = AbstractPdoTest.runClass(testClass, new String[0]);
        AbstractPdoTest.waitForProcess(process);
        return process.exitValue();
    }

    protected Session openSession() {
        Session s;
        try {
            s = Pdo.createSession();
        }
        catch (PersistenceException ex) {
            throw new SkipException("no backend found -> no tests", (Throwable)ex);
        }
        s.makeCurrent();
        return s;
    }

    protected void createDatabaseTables(Db db) {
        try {
            String script = DbTestUtilities.getInstance().createPopulateScript(db);
            DbTestUtilities.getInstance().runScript(db, script);
        }
        catch (ModelException e) {
            Assert.fail((String)"populating the database failed", (Throwable)e);
        }
    }

    protected void populateDatabase() {
    }

    protected DomainContext createDomainContext() {
        return Pdo.createDomainContext();
    }

    protected void beginTransaction() {
        if (session != null) {
            this.txVoucher = session.begin("test");
        }
    }

    protected void endTransaction() {
        if (session != null && session.isTxRunning()) {
            if (this.commit) {
                session.commit(this.txVoucher);
            } else {
                session.rollback(this.txVoucher);
            }
            this.txVoucher = 0L;
        }
    }

    public static Process runClass(Class<?> testClass, String ... args) throws IOException {
        String javaHome = System.getProperty("java.home");
        Object classPath = System.getProperty("java.class.path");
        String modulePath = System.getProperty("jdk.module.path");
        if (modulePath != null) {
            if (!((String)classPath).endsWith(":")) {
                classPath = (String)classPath + ":";
            }
            classPath = (String)classPath + modulePath;
        }
        Object[] cmd = new String[]{javaHome + File.separator + "bin" + File.separator + "java", "-cp", classPath, testClass.getName()};
        if (args != null && args.length > 0) {
            String[] aCmd = (String[])Arrays.copyOf(cmd, cmd.length + args.length);
            System.arraycopy(args, 0, aCmd, cmd.length, args.length);
            cmd = aCmd;
        }
        Reporter.log((String)("running: " + Arrays.toString(cmd) + "<br>"));
        return Runtime.getRuntime().exec((String[])cmd);
    }

    public static void waitForProcess(Process process) throws IOException {
        String line;
        try {
            process.waitFor();
        }
        catch (InterruptedException ex) {
            Assert.fail((String)("executing " + process + " failed<br>"), (Throwable)ex);
        }
        InputStreamReader r = new InputStreamReader(process.getInputStream());
        try (BufferedReader in = new BufferedReader(r);){
            while ((line = in.readLine()) != null) {
                Reporter.log((String)(line + "<br>"));
            }
        }
        r = new InputStreamReader(process.getErrorStream());
        in = new BufferedReader(r);
        try {
            while ((line = in.readLine()) != null) {
                Reporter.log((String)(line + "<br>"));
            }
        }
        finally {
            in.close();
        }
    }

    public static enum TransactionType {
        CLASS,
        METHOD,
        NONE;

    }
}

