/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.pdo.testng;

import java.util.Properties;
import org.tentackle.app.AbstractApplication;
import org.tentackle.dbms.Db;
import org.tentackle.misc.Identifiable;
import org.tentackle.model.ModelException;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.test.DbTestUtilities;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionInfo;
import org.tentackle.sql.Backend;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class TestApplication
extends AbstractApplication {
    public TestApplication(String name, String version) {
        super(name, version);
    }

    @BeforeClass(alwaysRun=true)
    public void setUpClass() throws Exception {
        Db db;
        Backend backend;
        Session session;
        SessionInfo sessionInfo = Pdo.createSessionInfo();
        sessionInfo.applyProperties();
        try {
            session = Pdo.createSession((SessionInfo)sessionInfo);
        }
        catch (PersistenceException ex) {
            throw new SkipException("no backend found -> no tests", (Throwable)ex);
        }
        Session.setCurrentSession((Session)session);
        boolean populate = false;
        if (session instanceof Db && (backend = (db = (Db)session).getBackend()).isDatabaseInMemory(session.getUrl())) {
            this.createDatabaseTables(db);
            populate = true;
        }
        if (this.getProperties() == null) {
            this.setProperties(new Properties());
        }
        this.applyProperties(sessionInfo.getProperties());
        if (!this.getProperties().containsKey("notracker")) {
            ModificationTracker.getInstance().setSession(session);
        }
        this.setDomainContext(Pdo.createDomainContext((Session)session));
        this.register();
        this.initializeScripting();
        if (populate) {
            this.populateDatabase();
        }
    }

    @AfterClass(alwaysRun=true)
    public void tearDownClass() throws Exception {
        Session session = this.getSession();
        if (session != null) {
            session.close();
            Session.setCurrentSession(null);
            this.unregister();
        }
    }

    protected void startup() {
    }

    public <U extends Identifiable> U getUser(DomainContext context, long userId) {
        return null;
    }

    protected void createDatabaseTables(Db db) {
        try {
            String script = DbTestUtilities.getInstance().createPopulateScript(db);
            DbTestUtilities.getInstance().runScript(db, script);
        }
        catch (ModelException e) {
            Assert.fail((String)"populating the database failed", (Throwable)e);
        }
    }

    protected void populateDatabase() {
    }
}

