/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.test.pdo;

import org.tentackle.app.AbstractApplication;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionInfo;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class TestApplication
extends AbstractApplication {
    private Session session;
    private DomainContext context;

    public TestApplication(String name) {
        super(name);
    }

    @BeforeClass(alwaysRun=true)
    public void setUpClass() throws Exception {
        SessionInfo sessionInfo = Pdo.createSessionInfo();
        try {
            this.session = Pdo.createSession((SessionInfo)sessionInfo);
        }
        catch (PersistenceException ex) {
            throw new SkipException("no backend found -> no tests");
        }
        Session.setCurrentSession((Session)this.session);
        ModificationTracker.getInstance().setSession(this.session);
        this.context = Pdo.createDomainContext((Session)this.session);
        this.register();
    }

    @AfterClass(alwaysRun=true)
    public void tearDownClass() throws Exception {
        if (this.session != null) {
            this.session.close();
            Session.setCurrentSession(null);
            this.unregister();
        }
    }

    public DomainContext getDomainContext() {
        return this.context;
    }

    public boolean isServer() {
        return false;
    }

    protected void startup() {
    }

    public <U extends PersistentDomainObject<U>> U getUser(DomainContext context, long userId) {
        return null;
    }
}

