/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.test.pdo;

import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import org.tentackle.dbms.rmi.RemoteDbConnectionImpl;
import org.tentackle.dbms.rmi.RemoteDbSession;
import org.tentackle.dbms.rmi.RemoteDbSessionImpl;
import org.tentackle.dbms.rmi.RmiServer;
import org.tentackle.log.Logger;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.persist.app.ServerApplication;
import org.tentackle.session.SessionInfo;

public class TestServer
extends ServerApplication {
    private static final Logger LOGGER = Logger.get(TestServer.class);
    private static final String DURATION = "duration=";

    public TestServer() {
        super("TestServer", ConnectionImpl.class);
    }

    public <U extends PersistentDomainObject<U>> U getUser(DomainContext context, long userId) {
        return null;
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        long duration = 10000L;
        for (String arg : args) {
            if (!arg.startsWith(DURATION)) continue;
            duration = Long.valueOf(arg.substring(DURATION.length()));
        }
        try {
            TestServer server = new TestServer();
            server.start(args);
            server.sleep(duration);
            server.stop();
        }
        catch (RuntimeException ex) {
            LOGGER.severe("test server failed", (Throwable)ex);
            System.exit(1);
        }
    }

    public static class SessionImpl
    extends RemoteDbSessionImpl {
        public SessionImpl(RemoteDbConnectionImpl con, SessionInfo clientInfo, SessionInfo serverInfo) {
            super(con, clientInfo, serverInfo);
        }

        public void verifySessionInfo(SessionInfo sessionInfo) {
        }
    }

    public static class ConnectionImpl
    extends RemoteDbConnectionImpl {
        private static final long serialVersionUID = 1L;

        public ConnectionImpl(RmiServer server, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
            super(server, port, csf, ssf);
        }

        public RemoteDbSession createSession(SessionInfo clientInfo) throws RemoteException {
            return new SessionImpl(this, clientInfo, this.getRmiServer().getSessionInfo().clone());
        }
    }
}

