/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.test.pdo;

import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import org.tentackle.common.InterruptedRuntimeException;
import org.tentackle.dbms.rmi.DbServer;
import org.tentackle.dbms.rmi.RemoteDbConnectionImpl;
import org.tentackle.dbms.rmi.RemoteDbSession;
import org.tentackle.dbms.rmi.RemoteDbSessionImpl;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.persist.app.ServerApplication;
import org.tentackle.session.LoginFailedException;
import org.tentackle.session.SessionInfo;

public class TestServer
extends ServerApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestServer.class);
    private static final String DURATION = "duration=";

    public TestServer() {
        super("TestServer", ConnectionImpl.class);
    }

    public <U extends PersistentDomainObject<U>> U getUser(DomainContext context, long userId) {
        return null;
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ix) {
            throw new InterruptedRuntimeException((Throwable)ix);
        }
    }

    public static void main(String[] args) {
        long duration = 10000L;
        for (String arg : args) {
            if (!arg.startsWith(DURATION)) continue;
            duration = Long.valueOf(arg.substring(DURATION.length()));
        }
        try {
            TestServer server = new TestServer();
            server.start(args);
            server.sleep(duration);
            server.stop();
        }
        catch (Exception ex) {
            LOGGER.severe("test server failed", (Throwable)ex);
            System.exit(1);
        }
    }

    public static class SessionImpl
    extends RemoteDbSessionImpl {
        public SessionImpl(RemoteDbConnectionImpl con, SessionInfo clientInfo, SessionInfo serverInfo) throws RemoteException {
            super(con, clientInfo, serverInfo);
        }

        public void verifySessionInfo(SessionInfo sessionInfo) throws LoginFailedException {
        }
    }

    public static class ConnectionImpl
    extends RemoteDbConnectionImpl {
        private static final long serialVersionUID = 1L;

        public ConnectionImpl(DbServer server, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
            super(server, port, csf, ssf);
        }

        public RemoteDbSession createSession(SessionInfo clientInfo) throws RemoteException {
            return new SessionImpl(this, clientInfo, this.getServer().getSessionInfo().clone());
        }
    }
}

