/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.update;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.OptionalLong;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.FileHelper;
import org.tentackle.update.ClientInfo;
import org.tentackle.update.UpdateInfo;
import org.tentackle.update.UpdateService;

public abstract class AbstractUpdateServiceImpl
extends UnicastRemoteObject
implements UpdateService {
    private static final long serialVersionUID = 1L;
    private final Map<URL, Long> downloadSizes = new ConcurrentHashMap<URL, Long>();
    private final Map<URL, String> shaHashes = new ConcurrentHashMap<URL, String>();
    private String updateURL;

    public AbstractUpdateServiceImpl(int port, String updateURL) throws RemoteException {
        super(port);
        this.setUpdateURL(updateURL);
    }

    public AbstractUpdateServiceImpl(int port, String updateURL, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
        this.setUpdateURL(updateURL);
    }

    public String getUpdateURL() {
        return this.updateURL;
    }

    public void setUpdateURL(String updateURL) {
        this.updateURL = updateURL.endsWith("/") ? updateURL : updateURL + "/";
    }

    @Override
    public UpdateInfo getInfo(ClientInfo clientInfo) throws RemoteException {
        try {
            URL zipURL = this.createZipURL(clientInfo);
            URL shaURL = this.createShaURL(clientInfo);
            String shaHash = this.determineShaHash(shaURL);
            long size = this.determineDownloadSize(zipURL);
            String updateExecutor = this.createUpdateExecutor(clientInfo);
            UpdateInfo updateInfo = new UpdateInfo(this.createServerVersion(), zipURL, shaHash, size, updateExecutor);
            return updateInfo;
        }
        catch (IOException ex) {
            throw new RemoteException("cannot create update info", ex);
        }
    }

    protected abstract String createServerVersion();

    protected abstract String createUpdateExecutor(ClientInfo var1);

    protected abstract URL createZipURL(ClientInfo var1);

    protected abstract URL createShaURL(ClientInfo var1);

    protected String determineShaHash(URL shaURL) throws IOException {
        String shaHash = this.shaHashes.get(shaURL);
        if (shaHash == null) {
            shaHash = new StringTokenizer(new String(FileHelper.download((URL)shaURL))).nextToken();
            this.shaHashes.put(shaURL, shaHash);
        }
        return shaHash;
    }

    protected long determineDownloadSize(URL zipURL) throws IOException {
        Long size = this.downloadSizes.get(zipURL);
        if (size == null) {
            try {
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(zipURL.toURI()).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                OptionalLong contentLength = response.headers().firstValueAsLong("content-length");
                size = contentLength.orElse(-1L);
                this.downloadSizes.put(zipURL, size);
            }
            catch (IOException iox) {
                throw iox;
            }
            catch (InterruptedException | URISyntaxException ex) {
                throw new IOException("cannot determine expected download size of " + zipURL, ex);
            }
        }
        return size;
    }
}

