/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.update;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.function.Consumer;
import org.tentackle.common.FileHelper;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.update.CallbackReadableByteChannel;
import org.tentackle.update.ClientUpdateUtilitiesHolder;
import org.tentackle.update.UpdateInfo;
import org.tentackle.update.UpdateService;

@Service(value=ClientUpdateUtilities.class)
public class ClientUpdateUtilities {
    private static final String[] DIR_NAMES = new String[]{".", "bin", "conf", "include", "legal", "lib"};

    public static ClientUpdateUtilities getInstance() {
        return ClientUpdateUtilitiesHolder.INSTANCE;
    }

    public boolean isApplicationUpdatable() {
        for (String dirName : DIR_NAMES) {
            File dir = new File(dirName);
            if (dir.isDirectory() && dir.canWrite()) continue;
            return false;
        }
        return true;
    }

    public UpdateService getUpdateService(String serviceName, RMIClientSocketFactory csf) {
        try {
            URI uri = new URI(serviceName);
            String host = uri.getHost();
            int port = uri.getPort();
            String path = uri.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            Registry registry = LocateRegistry.getRegistry(host, port, csf);
            return (UpdateService)registry.lookup(path);
        }
        catch (URISyntaxException | NotBoundException | RemoteException nx) {
            throw new TentackleRuntimeException("cannot connect to update service '" + serviceName + "'", (Throwable)nx);
        }
    }

    public File dowloadZip(UpdateInfo updateInfo, File updateDir, Consumer<Double> progressConsumer) {
        try {
            String zipName;
            int ndx;
            if (!updateDir.mkdir()) {
                FileHelper.removeDirectory((String)updateDir.getName());
                if (!updateDir.mkdir()) {
                    throw new TentackleRuntimeException("cannot create update directory");
                }
            }
            if ((ndx = (zipName = updateInfo.getUrl().getPath()).lastIndexOf(47)) >= 0) {
                zipName = zipName.substring(ndx + 1);
            }
            File zipFile = new File(updateDir, zipName);
            try (CallbackReadableByteChannel readableByteChannel = new CallbackReadableByteChannel(Channels.newChannel(updateInfo.getUrl().openStream()), updateInfo.getSize(), progressConsumer);
                 FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
                 FileChannel fileChannel = fileOutputStream.getChannel();){
                fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            }
            byte[] buffer = new byte[8192];
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(zipFile));){
                int count;
                while ((count = bis.read(buffer)) > 0) {
                    digest.update(buffer, 0, count);
                }
            }
            String shaHash = StringHelper.fillLeft((String)new BigInteger(1, digest.digest()).toString(16), (int)32, (char)'0');
            if (!shaHash.equals(updateInfo.getShaHash())) {
                throw new TentackleRuntimeException("checksum failed, expected " + updateInfo.getShaHash() + ", found " + shaHash);
            }
            return zipFile;
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new TentackleRuntimeException("download failed", (Throwable)ex);
        }
    }
}

