/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.update;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.function.Consumer;
import org.tentackle.common.FileHelper;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.update.CallbackReadableByteChannel;
import org.tentackle.update.ClientUpdateUtilitiesHolder;
import org.tentackle.update.InstallationType;
import org.tentackle.update.UpdateInfo;
import org.tentackle.update.UpdateService;

@Service(value=ClientUpdateUtilities.class)
public class ClientUpdateUtilities {
    private static final String[] JLINK_SUBDIR_NAMES = new String[]{".", "bin", "conf", "include", "legal", "lib"};

    public static ClientUpdateUtilities getInstance() {
        return ClientUpdateUtilitiesHolder.INSTANCE;
    }

    public boolean isUpdatableJlinkDirectory(File dir) {
        boolean isJlinkDirectory = true;
        if (dir.isDirectory() && Files.isWritable(Paths.get(dir.getAbsolutePath(), new String[0]))) {
            for (String dirName : JLINK_SUBDIR_NAMES) {
                File subdir = new File(dir, dirName);
                if (subdir.isDirectory() && Files.isWritable(Paths.get(subdir.getAbsolutePath(), new String[0]))) continue;
                isJlinkDirectory = false;
                break;
            }
        } else {
            isJlinkDirectory = false;
        }
        return isJlinkDirectory;
    }

    public boolean isUpdateableJlinkApplication() {
        return this.isUpdatableJlinkDirectory(new File("."));
    }

    public boolean isUpdatableJPackageApplication() {
        File runtimeDir = null;
        File rootDir = this.determineJPackageRoot();
        if (rootDir != null) {
            String platform = StringHelper.getPlatform();
            runtimeDir = platform.contains("win") ? new File(rootDir, "runtime") : (platform.contains("mac") ? new File(rootDir, "Contents/runtime/Contents/Home") : new File(rootDir, "lib/runtime"));
        }
        return runtimeDir != null && this.isUpdatableJlinkDirectory(runtimeDir);
    }

    public File determineJPackageRoot() {
        File rootDir = null;
        Optional<String> javaCommand = ProcessHandle.current().info().command();
        if (javaCommand.isPresent()) {
            File appDir = new File(javaCommand.get()).getParentFile();
            String platform = StringHelper.getPlatform();
            if (platform.contains("win")) {
                rootDir = appDir;
                if (!new File(rootDir, "app").isDirectory()) {
                    rootDir = null;
                }
            } else if (platform.contains("mac")) {
                if ("MacOS".equals(appDir.getName()) && !new File(rootDir = appDir.getParentFile().getParentFile(), "Contents").isDirectory()) {
                    rootDir = null;
                }
            } else if ("bin".equals(appDir.getName()) && !new File(rootDir = appDir.getParentFile(), "lib/app").isDirectory()) {
                rootDir = null;
            }
        }
        return rootDir;
    }

    public InstallationType determineInstallationType() {
        InstallationType type = null;
        if (this.isUpdateableJlinkApplication()) {
            type = InstallationType.JLINK;
        } else if (this.isUpdatableJPackageApplication()) {
            type = InstallationType.JPACKAGE;
        }
        return type;
    }

    public UpdateService getUpdateService(String serviceName, RMIClientSocketFactory csf) {
        try {
            URI uri = new URI(serviceName);
            String host = uri.getHost();
            int port = uri.getPort();
            String path = uri.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            Registry registry = LocateRegistry.getRegistry(host, port, csf);
            return (UpdateService)registry.lookup(path);
        }
        catch (URISyntaxException | NotBoundException | RemoteException nx) {
            throw new TentackleRuntimeException("cannot connect to update service '" + serviceName + "'", (Throwable)nx);
        }
    }

    public File dowloadZip(UpdateInfo updateInfo, File updateDir, Consumer<Double> progressConsumer) {
        try {
            String zipName;
            int ndx;
            if (!updateDir.mkdir()) {
                FileHelper.removeDirectory((String)updateDir.getName());
                if (!updateDir.mkdir()) {
                    throw new TentackleRuntimeException("cannot create update directory");
                }
            }
            if ((ndx = (zipName = updateInfo.getUrl().getPath()).lastIndexOf(47)) >= 0) {
                zipName = zipName.substring(ndx + 1);
            }
            File zipFile = new File(updateDir, zipName);
            try (CallbackReadableByteChannel readableByteChannel = new CallbackReadableByteChannel(Channels.newChannel(updateInfo.getUrl().openStream()), updateInfo.getSize(), progressConsumer);
                 FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
                 FileChannel fileChannel = fileOutputStream.getChannel();){
                fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            }
            byte[] buffer = new byte[8192];
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(zipFile));){
                int count;
                while ((count = bis.read(buffer)) > 0) {
                    digest.update(buffer, 0, count);
                }
            }
            String shaHash = StringHelper.fillLeft((String)new BigInteger(1, digest.digest()).toString(16), (int)32, (char)'0');
            if (!shaHash.equals(updateInfo.getShaHash())) {
                throw new TentackleRuntimeException("checksum failed, expected " + updateInfo.getShaHash() + ", found " + shaHash);
            }
            return zipFile;
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new TentackleRuntimeException("download failed", (Throwable)ex);
        }
    }
}

