/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.update;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.tentackle.common.Cryptor;
import org.tentackle.common.TentackleRuntimeException;

public class UpdateInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String version;
    private final String url;
    private final String shaHash;
    private final String size;
    private final String updateExecutor;
    private final boolean encrypted;

    public UpdateInfo(String version, URL url, String shaHash, long size, String updateExecutor) {
        Cryptor cryptor = Cryptor.getInstance();
        if (cryptor != null) {
            this.version = cryptor.encrypt64(version);
            this.url = cryptor.encrypt64(url.toExternalForm());
            this.shaHash = cryptor.encrypt64(shaHash);
            this.size = cryptor.encrypt64(Long.toString(size));
            this.updateExecutor = cryptor.encrypt64(updateExecutor);
            this.encrypted = true;
        } else {
            this.version = version;
            this.url = url.toExternalForm();
            this.shaHash = shaHash;
            this.size = Long.toString(size);
            this.updateExecutor = updateExecutor;
            this.encrypted = false;
        }
    }

    public String getVersion() {
        return this.encrypted ? Cryptor.getInstance().decrypt64(this.version) : this.version;
    }

    public URL getUrl() {
        try {
            return new URL(this.encrypted ? Cryptor.getInstance().decrypt64(this.url) : this.url);
        }
        catch (MalformedURLException mx) {
            throw new TentackleRuntimeException((Throwable)mx);
        }
    }

    public String getShaHash() {
        return this.encrypted ? Cryptor.getInstance().decrypt64(this.shaHash) : this.shaHash;
    }

    public long getSize() {
        return Long.valueOf(this.encrypted ? Cryptor.getInstance().decrypt64(this.size) : this.size);
    }

    public String getUpdateExecutor() {
        return this.encrypted ? Cryptor.getInstance().decrypt64(this.updateExecutor) : this.updateExecutor;
    }

    public String toString() {
        return "UpdateInfo{version='" + this.getVersion() + "', url=" + this.getUrl() + ", shaHash='" + this.getShaHash() + "', size=" + this.getSize() + ", updateExecutor='" + this.getUpdateExecutor() + "'}";
    }
}

