/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.update;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.function.Consumer;

public class CallbackReadableByteChannel
implements ReadableByteChannel {
    private final ReadableByteChannel channel;
    private final Consumer<Double> progressConsumer;
    private final long expectedSize;
    private int size;

    public CallbackReadableByteChannel(ReadableByteChannel channel, long expectedSize, Consumer<Double> progressConsumer) {
        this.channel = channel;
        this.expectedSize = expectedSize;
        this.progressConsumer = progressConsumer;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int n = this.channel.read(dst);
        if (n > 0) {
            this.size += n;
            if (this.progressConsumer != null) {
                double progress = this.size > 0 ? (double)this.size / (double)this.expectedSize : 0.0;
                this.progressConsumer.accept(progress);
            }
        }
        return n;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public int getSize() {
        return this.size;
    }
}

