/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.update;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.AlreadyBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import org.tentackle.common.Service;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.update.ServerUpdateUtilitiesHolder;
import org.tentackle.update.UpdateService;

@Service(value=ServerUpdateUtilities.class)
public class ServerUpdateUtilities {
    public static ServerUpdateUtilities getInstance() {
        return ServerUpdateUtilitiesHolder.INSTANCE;
    }

    public void exportUpdateService(String serviceUrlName, String updateUrlName, Class<? extends UpdateService> updateServiceImplClass, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        try {
            URI uri = new URI(serviceUrlName);
            int port = uri.getPort();
            Registry updateRegistry = csf != null && ssf != null ? LocateRegistry.createRegistry(port, csf, ssf) : LocateRegistry.createRegistry(port);
            String uriPath = uri.getPath();
            String serviceName = uriPath.startsWith("/") ? uriPath.substring(1) : uriPath;
            updateRegistry.bind(serviceName, this.createUpdateServiceImpl(updateServiceImplClass, port, updateUrlName, csf, ssf));
        }
        catch (URISyntaxException e) {
            throw new TentackleRuntimeException("malformed updateService URL '" + serviceUrlName + "'", (Throwable)e);
        }
        catch (RemoteException e) {
            throw new TentackleRuntimeException("cannot create update service", (Throwable)e);
        }
        catch (AlreadyBoundException e) {
            throw new TentackleRuntimeException("cannot bind update registry", (Throwable)e);
        }
    }

    public void exportUpdateService(String serviceUrlName, String updateUrlName, Class<? extends UpdateService> updateServiceImplClass) {
        this.exportUpdateService(serviceUrlName, updateUrlName, updateServiceImplClass, null, null);
    }

    protected UpdateService createUpdateServiceImpl(Class<? extends UpdateService> updateServiceImplClass, int port, String updateUrlName, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        try {
            if (csf != null && ssf != null) {
                Constructor<? extends UpdateService> constructor = updateServiceImplClass.getConstructor(Integer.TYPE, String.class, RMIClientSocketFactory.class, RMIServerSocketFactory.class);
                return constructor.newInstance(port, updateUrlName, csf, ssf);
            }
            Constructor<? extends UpdateService> constructor = updateServiceImplClass.getConstructor(Integer.TYPE, String.class);
            return constructor.newInstance(port, updateUrlName);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new TentackleRuntimeException("cannot create update service " + updateServiceImplClass.getName(), (Throwable)ex);
        }
    }
}

