/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.update;

import java.io.Serializable;
import java.util.Objects;
import org.tentackle.common.StringHelper;
import org.tentackle.update.InstallationType;

public class ClientInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String application;
    private final String version;
    private final String platform;
    private final String architecture;
    private final InstallationType installationType;

    public ClientInfo(String application, String version, String platform, String architecture, InstallationType installationType) {
        this.application = Objects.requireNonNull(application);
        this.version = Objects.requireNonNull(version);
        this.platform = Objects.requireNonNull(platform);
        this.architecture = Objects.requireNonNull(architecture);
        this.installationType = Objects.requireNonNull(installationType);
    }

    public ClientInfo(String application, String version, InstallationType installationType) {
        this(application, version, StringHelper.getPlatform(), StringHelper.getArchitecture(), installationType);
    }

    public String getApplication() {
        return this.application;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public InstallationType getInstallationType() {
        return this.installationType;
    }

    public String toString() {
        return "ClientInfo{application='" + this.application + "', version='" + this.version + "', platform='" + this.platform + "', architecture='" + this.architecture + "', installationType=" + this.installationType + "}";
    }
}

