/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.update;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.tentackle.common.Cryptor;
import org.tentackle.common.TentackleRuntimeException;

public class UpdateInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String version;
    private final String url;
    private final String checksum;
    private final String size;
    private final String updateExecutor;
    private final boolean encrypted;

    public UpdateInfo(String version, URL url, String checksum, long size, String updateExecutor) {
        Cryptor cryptor = Cryptor.getInstance();
        if (cryptor != null) {
            this.version = cryptor.encrypt64(version);
            this.url = cryptor.encrypt64(url.toExternalForm());
            this.checksum = cryptor.encrypt64(checksum);
            this.size = cryptor.encrypt64(Long.toString(size));
            this.updateExecutor = cryptor.encrypt64(updateExecutor);
            this.encrypted = true;
        } else {
            this.version = version;
            this.url = url.toExternalForm();
            this.checksum = checksum;
            this.size = Long.toString(size);
            this.updateExecutor = updateExecutor;
            this.encrypted = false;
        }
    }

    public String getVersion() {
        return this.encrypted ? Cryptor.getInstance().decrypt64(this.version) : this.version;
    }

    public URL getUrl() {
        try {
            return new URL(this.encrypted ? Cryptor.getInstance().decrypt64(this.url) : this.url);
        }
        catch (MalformedURLException mx) {
            throw new TentackleRuntimeException((Throwable)mx);
        }
    }

    public String getChecksum() {
        return this.encrypted ? Cryptor.getInstance().decrypt64(this.checksum) : this.checksum;
    }

    public long getSize() {
        return Long.parseLong(this.encrypted ? Cryptor.getInstance().decrypt64(this.size) : this.size);
    }

    public String getUpdateExecutor() {
        return this.encrypted ? Cryptor.getInstance().decrypt64(this.updateExecutor) : this.updateExecutor;
    }

    public String toString() {
        return "UpdateInfo{version='" + this.getVersion() + "', url=" + this.getUrl() + ", checksum='" + this.getChecksum() + "', size=" + this.getSize() + ", updateExecutor='" + this.getUpdateExecutor() + "'}";
    }
}

