/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.update;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.OptionalLong;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.FileHelper;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.update.ClientInfo;
import org.tentackle.update.InstallationType;
import org.tentackle.update.UpdateInfo;
import org.tentackle.update.UpdateService;

public abstract class AbstractUpdateServiceImpl
extends UnicastRemoteObject
implements UpdateService {
    private static final long serialVersionUID = 1L;
    private final Map<String, Long> downloadSizes = new ConcurrentHashMap<String, Long>();
    private final Map<String, String> checksumHashes = new ConcurrentHashMap<String, String>();
    private String updateURL;

    public AbstractUpdateServiceImpl(int port, String updateURL) throws RemoteException {
        super(port);
        this.setUpdateURL(updateURL);
    }

    public AbstractUpdateServiceImpl(int port, String updateURL, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
        this.setUpdateURL(updateURL);
    }

    public abstract String getArtifactName();

    public abstract String getVersion();

    public String getUpdateURL() {
        return this.updateURL;
    }

    public void setUpdateURL(String updateURL) {
        this.updateURL = updateURL.endsWith("/") ? updateURL : updateURL + "/";
    }

    @Override
    public UpdateInfo getUpdateInfo(ClientInfo clientInfo) throws RemoteException {
        try {
            URL zipURL = this.createZipURL(clientInfo);
            URL checksumURL = this.createChecksumURL(clientInfo);
            String checksumHash = this.determineChecksumHash(checksumURL);
            long size = this.determineDownloadSize(zipURL);
            String updateExecutor = this.createUpdateExecutor(clientInfo);
            return this.createUpdateInfo(this.getVersion(), zipURL, checksumHash, size, updateExecutor);
        }
        catch (IOException ex) {
            throw new RemoteException("cannot create update info", ex);
        }
    }

    protected UpdateInfo createUpdateInfo(String version, URL zipURL, String checksumHash, long size, String updateExecutor) {
        return new UpdateInfo(version, zipURL, checksumHash, size, updateExecutor);
    }

    protected String createUpdateExecutor(ClientInfo clientInfo) {
        return clientInfo.getPlatform().contains("win") ? "update.cmd" : "update.sh";
    }

    protected URL createZipURL(ClientInfo clientInfo) {
        try {
            return new URL(this.createBaseUrlName(clientInfo) + ".zip");
        }
        catch (MalformedURLException e) {
            throw new TentackleRuntimeException((Throwable)e);
        }
    }

    protected URL createChecksumURL(ClientInfo clientInfo) {
        try {
            return new URL(this.createBaseUrlName(clientInfo) + ".sha256");
        }
        catch (MalformedURLException e) {
            throw new TentackleRuntimeException((Throwable)e);
        }
    }

    protected String createBaseUrlName(ClientInfo clientInfo) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getUpdateURL()).append(this.getArtifactName()).append('-').append(this.getVersion()).append('-').append(clientInfo.getPlatform()).append('-').append(clientInfo.getArchitecture());
        if (clientInfo.getInstallationType() == InstallationType.JPACKAGE) {
            buf.append("-pkg");
        }
        return buf.toString();
    }

    protected String determineChecksumHash(URL checksumURL) throws IOException {
        String checksumUrlStr = checksumURL.toString();
        String shaHash = this.checksumHashes.get(checksumUrlStr);
        if (shaHash == null) {
            shaHash = new StringTokenizer(new String(FileHelper.download((URL)checksumURL))).nextToken();
            this.checksumHashes.put(checksumUrlStr, shaHash);
        }
        return shaHash;
    }

    protected long determineDownloadSize(URL zipURL) throws IOException {
        String zipUrlStr = zipURL.toString();
        Long size = this.downloadSizes.get(zipUrlStr);
        if (size == null) {
            try {
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(zipURL.toURI()).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                OptionalLong contentLength = response.headers().firstValueAsLong("content-length");
                size = contentLength.orElse(-1L);
                this.downloadSizes.put(zipUrlStr, size);
            }
            catch (InterruptedException | URISyntaxException ex) {
                throw new IOException("cannot determine expected download size of " + zipUrlStr, ex);
            }
        }
        return size;
    }
}

