/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.web.app;

import java.util.Collection;
import org.tentackle.dbms.Db;
import org.tentackle.persist.app.AbstractServerApplication;
import org.tentackle.session.Session;
import org.tentackle.session.SessionInfo;
import org.tentackle.web.app.WebSessionKeyCache;

public abstract class WebApplication<T>
extends AbstractServerApplication {
    private WebSessionKeyCache<T> sessionCache;

    public static <T> WebApplication<T> getWebApplication() {
        return (WebApplication)WebApplication.getRunningApplication();
    }

    public WebApplication(String name, String version) {
        super(name, version);
    }

    public void addWebSession(T sessionKey, SessionInfo userInfo) {
        this.sessionCache.addSession(sessionKey, userInfo);
    }

    public void removeWebSession(T sessionKey) {
        this.sessionCache.removeSession(sessionKey);
    }

    public Collection<T> getSessionKeys(SessionInfo sessionInfo) {
        return this.sessionCache.getSessionKeys(sessionInfo);
    }

    public Session getSession(T sessionKey) {
        SessionInfo sessionInfo = this.sessionCache.getSession(sessionKey);
        if (sessionInfo != null) {
            Db db = (Db)this.getSessionPool().getSession();
            db.setSessionInfo(sessionInfo);
            return db;
        }
        return null;
    }

    public void putSession(Session session) {
        ((Db)session).setSessionInfo(null);
        this.getSessionPool().putSession(session);
    }

    protected void startup() {
        this.sessionCache = new WebSessionKeyCache();
        super.startup();
    }

    protected void finishStartup() {
        super.finishStartup();
        this.sessionCache.startup(300000L);
    }

    protected void cleanup() {
        if (this.sessionCache != null) {
            this.sessionCache.terminate();
            this.sessionCache = null;
        }
        super.cleanup();
    }
}

