/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.web.app;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.session.SessionInfo;

public class WebSessionKeyCache<T> {
    private final ConcurrentHashMap<T, SoftReference<SessionInfo>> userInfoMap = new ConcurrentHashMap();
    private CleanupThread cleanupThread;

    public void startup(long cleanupInterval) {
        if (cleanupInterval <= 0L) {
            throw new IllegalArgumentException("cleanupInterval must be > 0");
        }
        if (this.cleanupThread != null && this.cleanupThread.isAlive()) {
            throw new TentackleRuntimeException("session cache cleanup thread already running");
        }
        this.cleanupThread = new CleanupThread(cleanupInterval);
        this.cleanupThread.start();
    }

    public void terminate() {
        if (this.cleanupThread != null) {
            boolean isAlive = this.cleanupThread.isAlive();
            if (isAlive) {
                this.cleanupThread.requestToStop();
                try {
                    this.cleanupThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.cleanupThread = null;
            if (!isAlive) {
                throw new TentackleRuntimeException("session cache cleanup thread died");
            }
        } else {
            throw new TentackleRuntimeException("session cache cleanup thread hasn't been started");
        }
    }

    public void addSession(T sessionKey, SessionInfo sessionInfo) {
        this.userInfoMap.put(sessionKey, new SoftReference<SessionInfo>(sessionInfo));
    }

    public void removeSession(T sessionKey) {
        this.userInfoMap.remove(sessionKey);
    }

    public SessionInfo getSession(T sessionKey) {
        SoftReference<SessionInfo> sessionInfoRef = this.userInfoMap.get(sessionKey);
        if (sessionInfoRef != null) {
            SessionInfo userInfo = sessionInfoRef.get();
            if (userInfo != null) {
                return userInfo;
            }
            this.removeSession(sessionKey);
        }
        return null;
    }

    public Collection<T> getSessionKeys(SessionInfo sessionInfo) {
        ArrayList<T> sessionKeys = new ArrayList<T>();
        Iterator<Map.Entry<T, SoftReference<SessionInfo>>> iter = this.userInfoMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<T, SoftReference<SessionInfo>> entry = iter.next();
            SessionInfo info = entry.getValue().get();
            if (info == null) {
                iter.remove();
                continue;
            }
            if (!info.equals(sessionInfo)) continue;
            sessionKeys.add(entry.getKey());
        }
        return sessionKeys;
    }

    private class CleanupThread
    extends Thread {
        private final long ms;
        private boolean stop;

        private CleanupThread(long ms) {
            this.ms = ms;
            this.setDaemon(true);
        }

        private void requestToStop() {
            this.stop = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!CleanupThread.interrupted() && !this.stop) {
                try {
                    CleanupThread.sleep(this.ms);
                    WebSessionKeyCache.this.userInfoMap.values().removeIf(ref -> ref.get() == null);
                }
                catch (InterruptedException ex) {
                    if (!this.stop) continue;
                    break;
                }
            }
        }
    }
}

