/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.web.app;

import java.util.Collection;
import org.tentackle.dbms.Db;
import org.tentackle.persist.app.AbstractServerApplication;
import org.tentackle.session.MultiUserSessionPool;
import org.tentackle.session.Session;
import org.tentackle.session.SessionInfo;
import org.tentackle.session.SessionPool;
import org.tentackle.web.app.WebSessionKeyCache;

public abstract class WebApplication<T>
extends AbstractServerApplication {
    private WebSessionKeyCache<T> sessionInfoCache;

    public WebApplication(String name, String version) {
        super(name, version);
    }

    public void addWebSession(T sessionKey, SessionInfo sessionInfo) {
        this.sessionInfoCache.addSessionInfo(sessionKey, sessionInfo);
    }

    public void removeWebSession(T sessionKey) {
        this.sessionInfoCache.removeSessionInfo(sessionKey);
    }

    public Collection<T> getSessionKeys(SessionInfo sessionInfo) {
        return this.sessionInfoCache.getSessionKeys(sessionInfo);
    }

    public Session getSession(T sessionKey) {
        SessionInfo sessionInfo = this.sessionInfoCache.getSessionInfo(sessionKey);
        if (sessionInfo != null) {
            SessionPool sessionPool = this.getSessionPool();
            Db session = null;
            if (sessionPool != null) {
                session = (Db)sessionPool.getSession();
            } else {
                MultiUserSessionPool remoteSessionPool = this.getRemoteSessionPool();
                if (remoteSessionPool != null) {
                    session = (Db)remoteSessionPool.get(sessionInfo);
                }
            }
            if (session != null) {
                session.setSessionInfo(sessionInfo);
                return session;
            }
        }
        return null;
    }

    public void putSession(Session session) {
        if (this.getSessionPool() != null) {
            ((Db)session).setSessionInfo(null);
        }
        session.getPool().putSession(session);
    }

    protected void startup() {
        this.sessionInfoCache = new WebSessionKeyCache();
        super.startup();
    }

    protected void finishStartup() {
        super.finishStartup();
        this.sessionInfoCache.startup(300000L);
    }

    protected void cleanup() {
        if (this.sessionInfoCache != null) {
            this.sessionInfoCache.terminate();
            this.sessionInfoCache = null;
        }
        super.cleanup();
    }
}

